\version "2.22.2"

\header {
  texidoc = "
Polyrhythmic pieces (with different rhythms in different staves) are
not processed propperly with default settings. The BarLines crash as
well as Timing. The solution is to assign the respective engravers to
the Staff context.

"
  doctitle = "polyrhythmic staves"
}
% For polyrhythmic pieces we have to remove some engravers
% from score context and assign them to staff context.
% This snippet makes no use of Repeat_acknowledge_engraver and Volta_engraver
% But to make it easier to adapt the snippet to different needs,
% these engravers are mentioned here, too. You will need them as soon as you use \repeat.

upperVoice = \relative c'' {
  \override Staff.BarLine.allow-span-bar = ##f
  \time 3/4
  e4 f g
  a g f % since Staff.BarLine.allow-span-bar is set to ##f, bar lines are not connected
  e f g
  % if we want the BarLines of the Staves to be connected, we have to turn it on again
  a g f\bar"|." \once \override Staff.BarLine.allow-span-bar = ##t
}

lowerVoice = \relative c'' {
  \time 4/4
  c1
  c1
  c1\bar"|."
}

\score {
  \new StaffGroup <<
    \new Staff <<
      \new Voice { \upperVoice }
    >>
    \new Staff <<
      \new Voice { \lowerVoice }
    >>
  >>

  \layout {
    \context {
      \Score
      \remove "Timing_translator"
      %\remove "Repeat_acknowledge_engraver"
      %\remove "Volta_engraver"
    }

    \context{
      \Staff
      \consists "Timing_translator"
      %\consists "Repeat_acknowledge_engraver"
      %\consists "Volta_engraver"
    }
  }
}


