\version "2.22.2"

\header {
  texidoc = "
Sometimes, an author may want to display rests not with their usual
symbols, but e.g. use a circle instead of a quarter rest and a circle
with a rectangle below for eighth rests.

This snippet provides a Scheme function for the Rest's #'stencil
property, which creates circles instead of the usual rest symbols for
quarter and eighth rests, but uses the standard symbols for all other
rests. This is done by checking the duration-log property of the rest
object and provide a custom stencil for log values of 2 and 3 (because
1/4 = 2-2 and 1/8 = 2-3). For all other values, the built-in rest
formatter function is called.

To enable this style only for some parts of a score, don't set the
stencil globally, but call the \\override somewhere inside the score
and \\revert it after the section with the custom style:


\\relative c' @{
  e4. r8 e4 r4
  \\override Rest #'stencil = #ly:rest-interface::dot-rests
  e4. r8 e4 r4
  \\revert Rest #'stencil
  e4. r8 e4 r4 @}

To enable this style globally, simply override the #'stencil property
of the Rest object in a layout block:


\\layout @{
  \\context @{
    \\Voice
    \\override Rest #'stencil = #ly:rest-interface::dot-rests
  @} @}



"
  doctitle = "Using a different rest stencil globally (e.g., printing rests as circles)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=548

% Our own stencil for rests: quarter rests are shown as a centered filled circle, 
% eighth rests are an underlined filled circle:
#(define (ly:rest-interface::dot-rests grob)
  (let ((duration (ly:grob-property grob 'duration-log))
        (circle (ly:stencil-translate-axis (make-circle-stencil 0.55 0.1 #t) 0.3 X)))
    (case duration
      ((2) circle)
      ((3) (ly:stencil-add
               circle
               (make-filled-box-stencil '(-0.275 . 0.9) '(-1.35 . -1.0))))
      (else (ly:rest::print grob)))))

\layout {
  \context {
    \Voice
    \override Rest.stencil = #ly:rest-interface::dot-rests
  }
}

\relative c' {
  R1 |
  r2 e |
  e4. r8 e4 r4 |
  r8. r16 r4. r8 e4 |
}

% If you want this rest style only for some parts of a score, remove the 
% \layout block above and simply override the Rest stencil wherever you want.
% After the block with circle rests, simply revert the stencil property to its
% default values:
% \relative c' {
%   e4. r8 e4 r4
%   \override Rest.stencil = #ly:rest-interface::dot-rests
%   e4. r8 e4 r4
%   \revert Rest.stencil
%   e4. r8 e4 r4
% }



