\version "2.22.2"

\header {
  texidoc = "
Until the late 17th century, vocal parts were printed using specific
clefs for each voice. In modern editions, the modern clef is printed
but sometimes it is preceded by the traditional clef.

Here is how to achieve it in LilyPond: you have to replace the clef
symbol by a \\markup block, and that can only be done by overriding the
'stencil property to make it print a text element. Then you have to
define this text element as a markup, and insert in it the \\musicglyph
you need.

Notice the \\raise command: it is used to place the C clef properly on
the staff.

"
  doctitle = "Printing both the ancient and the modern clef in vocal music"
}
%% http://lsr.di.unimi.it/LSR/Item?id=370

\relative c' { 
  \once \override Staff.Clef.stencil = #ly:text-interface::print
  \once \override Staff.Clef.text = 
  \markup { \raise #-1 \musicglyph "clefs.C_change" \musicglyph "clefs.G" }
  \once \override Staff.Clef.X-extent = #'(0 . 6)
  \clef treble a' b c d \break b c a c
}
\layout {
  indent = 0
  ragged-right = ##t
}



