\version "2.22.2"

\header {
  texidoc = "
It may sometimes be necessary to have a single score with numbered
pages that are consecutive but you want to skip specified page ranges. 
This snippet shows how to specify a list of page number ranges to
print, with numbers not in the list omitted. Page numbers greater than
the last number in the range list will be printed consecutively as per
normal. For example, specifying a list of page ranges '((1) (3 5) (7
10)) would skip pages 2 and 6, and continue with consecutive numbering
from 11 onwards. (Please note: only first page is displayed in preview)


"
  doctitle = "Page Range Numbering"
}
#(define-markup-command (use-page-number-ranges layout props)()
  "Reads @code{'page-number-ranges} from @var{layout} and transforms it into a
flat list of integers.  Prints a number-string taken from this list for 
page-numbering.
The values are referenced by the actual page-number.  If all elements of this 
list are consumed, additional pages are numbered consecutively. 
An empty list will cause default page-numbers, as will non-list settings or
unsetting of @code{'page-number-ranges}

Limitations: 
  - doesn't work for roman page-numbers.
  - only integer page-numbers are supported"
  
  (define (page-numbers ranges)
    ;; get a flat, unfolded list from a list containing ranges of integers.
    ;; p.e. '((1) (3 5) (7 10)) -> '(1 3 4 5 7 8 9 10)
    (append-map 
      (lambda (e) 
        (if (every integer? e)
            (iota (- (last e) (1- (car e))) (car e) 1)
            (ly:error "All elements need to be integers: ~a" e))) 
        ranges))
  
  (let* ((page-number (chain-assoc-get 'page:page-number props -1))
         (page-number-ranges (ly:output-def-lookup layout 'page-number-ranges))
         (ls 
           (if (and (list? page-number-ranges) 
                    (every number-list? page-number-ranges))
               (page-numbers page-number-ranges)
               '()))
         (len (length ls)))

    (interpret-markup layout props
      (if (not (null? ls))
          (number->string
               (if (and (not (zero? page-number)) (< page-number len))
                   (list-ref ls (1- page-number))
                   (+ page-number (- (last ls) len))))
          (make-fromproperty-markup 'page:page-number-string)))))
           
                 
\paper {
  print-first-page-number = ##t
  print-page-number = ##t
  page-number-ranges = #'((1) (3 5) (7 10))
  oddHeaderMarkup = \markup 
  \fill-line {
    " "
    \unless \on-first-page \fromproperty #'header:instrument
    \if \should-print-page-number \use-page-number-ranges
  }
  evenHeaderMarkup = \markup
  \fill-line {
    \if \should-print-page-number \use-page-number-ranges
    \unless \on-first-page \fromproperty #'header:instrument
    " "
  }
}

\score {
  \new Staff {
    \repeat unfold 15 { c''1 \pageBreak }
  }
}


