\version "2.22.2"

\header {
  texidoc = "
While it is trivial to create individual dynamic markings, if a more
complex dynamic is required that LilyPond does not offer 'as standard'
then it is quite easy to create your own. This also has the advantage
of centering correctly without the need for more complex h-align
positioning.



"
  doctitle = "How to create custom dynamic markings"
}
%% http://lsr.di.unimi.it/LSR/Item?id=789

% Based on http://lsr.di.unimi.it/LSR/Snippet?id=382
% the #:hspace value controls the amount of space between each dynamic symbol.

dynamicOne = #(make-dynamic-script (markup #:line ( 
             #:dynamic "f" 
             #:dynamic "z" 
             #:dynamic "p" )))

dynamicTwo = #(make-dynamic-script (markup #:line ( 
             #:dynamic "p" #:hspace -0.5 
             #:dynamic "z"  #:hspace -0.5 
             #:dynamic "f"  #:hspace -0.5 
             #:dynamic "z"  #:hspace -0.5 
             #:dynamic "p" )))

dynamicThree = #(make-dynamic-script (markup #:line ( 
             #:dynamic "s" #:hspace -0.8 
             #:dynamic "f" #:hspace -0.8 
             #:dynamic "z" #:hspace -0.8 
             #:dynamic "z" #:hspace -0.8  
             #:dynamic "z" #:hspace -0.8  
             #:dynamic "z"  #:hspace -0.8  
             #:dynamic "p" )))

\relative c'' {
  c1\dynamicOne c2 c c1\dynamicTwo c2 c c1\dynamicThree
}



