\version "2.22.2"

\header {
  texidoc = "
One subtype of the grace synchronization issue is the grace echo.
  It occurs if one voice sends an (system wide collected) event (e.g.
start of repeat, start or end of volta)
  before a grace note, while another voice does it after this grace note
(usually
  because there is no grace note in the other voice). Then simply
ignoring the second
  occurrence after the grace notes is a quick help.

  Off course, it cannot help if there is no event before the first grace
note at all,
  e.g. if you use a parallel control voice without grace notes to define
the repeat
  structure.

  With the \\repeat and \\alternative commands this method is a little
tricky,
  because it must be done within an exact sequence of the other
engravers. This example
  illustrates how it's done 'directly' by context modifications and using
a scheme
  engraver, and this source code also describes how it will be
implemented by patching
  your LILYPOND installation. 

"
  doctitle = "Repeat commands grace echo purger"
}
%by: ArnoldTheresius

#(define-public (Local_repeatcommands_graceecho_purger ctx)
  (let ((last-main-moment -1)
        (accumulated-repeat-list '()))
    (make-engraver
      ((process-music trans)
         (let*
           ((now-mom (ly:context-current-moment ctx))
            (now-main-mom (ly:moment-main now-mom))
            (current-repeat-list (ly:context-property ctx 'repeatCommands)))
           (if (not (equal? last-main-moment now-main-mom))
               (set! accumulated-repeat-list '()))
           (if (not (null? current-repeat-list))
               (let ((new-repeat-list '()))
                (for-each 
                  (lambda (x)
                    (let ((tokken x))
                      (if (pair? x) ;;; only volta expected!
                          (if (and (boolean? (cadr x)) (eq? (cadr x) #f))
                            (set! tokken 'volta--end)
                            (set! tokken 'volta--start)))
                      (if (not (memq tokken accumulated-repeat-list)) 
                          (begin
                            (set! new-repeat-list (cons x new-repeat-list))
                            (set! accumulated-repeat-list 
                                  (cons tokken accumulated-repeat-list)))))) 
                  current-repeat-list)
                (ly:context-set-property! 
                  ctx 'repeatCommands 
                  (reverse! new-repeat-list))))
           (set! last-main-moment now-main-mom))))))



Music = {
  \tag #'Grace \acciaccatura b8 c'1
  \inStaffSegno
  \repeat volta 2 {
    \tag #'Grace \acciaccatura b8 c'1
  }
  \alternative {
    {
      \tag #'Grace \acciaccatura b8 c'1
    } {
      \tag #'Grace \acciaccatura b8 c'1
    }
  }
  \tag #'Grace \acciaccatura b8 c'1
}

\score {
  \new StaffGroup <<
    \new Staff {
      \Music
    }
    \new Staff {
      \removeWithTag #'Grace \Music
    }
  >>
  \layout {
    \context { \Score
      \remove "Repeat_acknowledge_engraver"
      \remove "Volta_engraver"
      % this scheme engraver defined above must be placed
      % before the 'Repeat_acknowledge_engraver', and all
      % dependent engravers (i.e. the "Volta_engraver")
      % must follow.
      % As there is no »before engraver xxx« option in
      % the '\consists' command, I did remove both before
      % I added the new scheme engraver, then I added
      % the two engravers again.
      \consists #Local_repeatcommands_graceecho_purger
      \consists "Repeat_acknowledge_engraver"
      \consists "Volta_engraver"

      %%% I have already patched my LILYPOND as listed below!
      %%% This is the syntax how to disable this patch in a \score block
      % \remove #Repeatcommands_graceecho_purger
    }
  }
}

\score {
  \new Staff { e'1 \inStaffSegno e' \inStaffSegno \repeat volta 2 { e' }  }
}

\markup \wordwrap {
  If you want to use it in every compilation, you may patch your LILYPOND installation:
  Follow the instruction you'll find here in the source code.
}
%{
  PATCH INSTRUCTION:

  1. locate the file
     .../usr/share/lilypond/current/scm/music-functions.scm
     and append these 27 lines:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Extension for grace echo purging
(define-public (Repeatcommands_graceecho_purger ctx)
  (let ((last-main-moment -1)
        (accumulated-repeat-list '()))
    (make-engraver
      ((process-music trans)
       (let*
         ((now-mom (ly:context-current-moment ctx))
          (now-main-mom (ly:moment-main now-mom))
          (current-repeat-list (ly:context-property ctx 'repeatCommands)))
         (if (not (equal? last-main-moment now-main-mom))
           (set! accumulated-repeat-list '()))
         (if (not (null? current-repeat-list))
           (let ((new-repeat-list '()))
            (for-each (lambda (x)
              (let ((tokken x))
                (if (pair? x) ;;; only volta expected!
                  (if (and (boolean? (cadr x)) (eq? (cadr x) #f))
                    (set! tokken 'volta--end)
                    (set! tokken 'volta--start)))
                (if (not (memq tokken accumulated-repeat-list)) (begin
                  (set! new-repeat-list (cons x new-repeat-list))
                  (set! accumulated-repeat-list (cons tokken accumulated-repeat-list)))))
             ) current-repeat-list)
            (ly:context-set-property! ctx 'repeatCommands (reverse! new-repeat-list))))
         (set! last-main-moment now-main-mom))))))

  2. locate the file
     .../usr/share/lilypond/current/ly/engraver-init.ly,
     open it with an text editor,
     find the line containing
       \consists "Repeat_acknowledge_engraver"
     and add just _b_e_f_o_r_e_ this the line
       \consists #Repeatcommands_graceecho_purger

%}



