\version "2.22.2"

\header {
  texidoc = "
The @code{\\autochange} command usually allows to switch staves when
reaching the middle C. However, here is a way to specify a different
pitch as the \"turning point\".

"
  doctitle = "autochange music with a different pitch"
}
%% http://lsr.di.unimi.it/LSR/Item?id=724

% by David Kastrup (Feb. 2014)

autoChangeWithPitch =
#(define-music-function (ref music) ((ly:pitch?) ly:music?)
  (let ((mus (make-autochange-music
              (if ref #{ \transpose $ref c' $music #} music))))
   (set! (ly:music-property mus 'element) music)
   mus))

\context PianoStaff <<
 \context Staff = "up" {
   \autoChangeWithPitch a \new Voice << \relative c' {
       g4 c e d c r4 a g } >>
 }
 \context Staff = "down" {
   \clef bass
   s1*2
 }
>>



