\version "2.22.2"

\header {
  texidoc = "
Lyrics can also be placed above the staff to which they are assigned
to. However, in this case you cannot simply place the line with
@code{\\lyricsto} above the staff definition, because at that point the
voice to which the lyrics are assigned has not been created. Thus, you
have to insert an empty dummy definition 

  \\new Lyrics = \"lyricsname\" @{ s4 @}
  \\new Staff = \"staffname\" << .... >>

and do the actual lyrics assignment later:

  \\context Lyrics = \"lyricsname\" \\lyricsto \"voicename\"
\\lyricsdefinition

This snippet is a simple example how to add lyrics above and/or below
the staff. 

"
  doctitle = "Lyrics above the staff they are assigned to"
}
%% http://lsr.di.unimi.it/LSR/Item?id=391

%here starts the snippet:

\header { tagline = ##f }

notes = \relative c' { c4 d e f | g a b c |}
lyricsAbove = \lyricmode { These ly -- rics placed a -- bove the staff... }
lyricsBelow = \lyricmode { These ly -- rics placed be -- low the staff... }

\score {
% Wrap everything in a parallel music section (otherwise you'll get errors!)
  <<
    % create empty dummy lyrics contexts, we'll do the actual assignment later
    % Important: The names will later be used to assign the correct placement!
    % We can't do the assignment before the voice has been defined, so the 
    % first Lyrics can't be replaced by \lyricsto, because the voice to which
    % it is assigned is not yet created there!!!
  
    % Lyrics above (because created before the staff)
    \new Lyrics = "above" { s4 }
    \new Staff <<
      \new Voice = "mainvoice" << \notes >>
    >>
    % Lyrics below (because created after the staff)
    \new Lyrics = "below" { s4 }
  
    % Now that we have created the Lyrics objects in the correct order, assign the lyrics
    % Notice the Lyrics = "name", where name is the same as in the above definitions!
    \context Lyrics = "above" \lyricsto "mainvoice" \lyricsAbove
    \context Lyrics = "below" \lyricsto "mainvoice" \lyricsBelow
  >>
}

