\version "2.22.2"

\header {
  texidoc = "
This is a technique that may aid in typesetting verses with very
similar melodies stacked on top of each other. Dashed slurs can be used
to indicate that two notes are sung separately in one verse and slurred
together in another.


Notice that the slurred notes are declared twice: once in the main
voice and again in the second voice, where they are hidden. It is these
two hidden notes that are connected with a dashed slur, leaving the
notes in the main voice free to align with any lyrics. The thickness of
the slur is also increased, to aid visibility.


To align the lyrics to the correct notes, place @code{\\skip}
instructions where lyrics should not be placed. The snippet
demonstrates that in the @code{\\lyricsto} mode durations are ignored,
so the argument to the @code{\\skip} command is arbitrary; it will
always skip the next note opportunity.


Ideally, this solution can be developed into a music function of its
own that takes the notes to be slurred as an argument. 

"
  doctitle = "Dashed slurs indicating optional slurs between lyric lines"
}
%% http://lsr.di.unimi.it/LSR/Item?id=308
%% => http://lilypond.1069038.n5.nabble.com/LSR-Dashed-slurs-indicating-optional-slurs-between-lyric-lines-tc168671.html

\score {
  <<
    \new Voice = "melody" \relative c' {
      \set melismaBusyProperties = #'()
      \slurDashed
      c8 e d-\tweak line-thickness #2.5 ( f ) e g f a
    }
    \new Lyrics \lyricsto "melody" {
      One two three four five six seven eight
    }
    \new Lyrics \lyricsto "melody" {
      One two Whee! \skip 8 that's a dashed slur!
    }
  >>
}


