\version "2.22.2"

\header {
  texidoc = "
To write a time signature as e.g. 3/(quarter note) instead of 3/4, you
can simply use the @code{format-time-sig-note} function defined in the
snippet for the @code{TimeSignature}'s @code{stencil} property, and it
will automatically extract the time signature and format it with a note
in the denominator instead of a number.

"
  doctitle = "Time signature style with note in the denominator (extracted automatically from the \\time call)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=642
%% see also http://lsr.di.unimi.it/LSR/Item?id=554

#(use-modules (ice-9 pretty-print))
#(define-public (format-time-sig-note grob)
   (let* ((frac (ly:grob-property grob 'fraction))
          (num (if (pair? frac) (car frac) 4))
          (den (if (pair? frac) (cdr frac) 4))
          (m (markup #:override '(baseline-skip . 0.5)
                     #:center-column (#:number (number->string num)
                                               #:override '(style . default)
                                               #:note 
                                                 (ly:make-duration (1- (integer-length den)) 0 1)
                                                 DOWN))))
     (grob-interpret-markup grob m)))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Some sample music
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\relative c' {
  \override Staff.TimeSignature.stencil = #format-time-sig-note
  \time 2/4
  \repeat unfold 4 c4

  \time 3/8
  \repeat unfold 3 c8

  \time 3/16
  \repeat unfold 3 c16

  \time 3/1
  \repeat unfold 3 c1

  \time 5/2
  \repeat unfold 5 c2

  \bar"|."
}



