\version "2.22.2"

\header {
  texidoc = "
There is a command to change slurs, @code{\\override Slur.positions}.
Actually the influence of this command is limited, e.g. if you like the
shape of the slur and you want to shift it a little bit,
@code{\\override Slur.positions} does not exactly what you want.
@code{slurShift} shifts the slur exactly the amount you want without
changing the shape, @code{slurShiftx} combines @code{slurShift} and
@code{Slur.positions}. 

"
  doctitle = "Manipulating slurs via 'positions and 'extra-offset"
}
\paper { tagline = ##f }

slurShift=
#(define-music-function (amount)
   (pair?)
   #{
     \once \override Slur.extra-offset = $amount
   #})

slurShiftx=
#(define-music-function (amount offsets)
   (pair? pair?)
   #{
     \once \override Slur.positions = $offsets
     \once \override Slur.extra-offset = $amount
   #})

\relative c, {
  \clef bass
  c8(-"default slur" g'' e' g, c g c g )
  \slurShift  #'(0 . 1)
  c,,8(-"slurShift #'(0 . 1)" g'' e' g, c g c g )
  \slurShiftx  #'(2 . 2) #'(0 . 6)
  c,,8(-"slurShiftx #'(2 . 2) #'(0 . 6)"
  g'' e' g, c g c g )
}


