\version "2.22.2"

\header {
  texidoc = "
If you want to modify the width of ledger lines (for example to make
them wider) you can do this by overriding the values of
@code{LedgerLineSpanner.length-fraction} and (optionally)
@code{LedgerLineSpanner.minimum-length-fraction}.

"
  doctitle = "Changing the width of ledger lines"
}
% Override LedgerLineSpanner.length-fraction to change the width
% of ledger lines. Its default setting is 0.25 which extends ledger
% lines beyond the note head on each side by 0.25 times the width
% of the note head. (1.0 is equal to the width of the note head.)
%
% LilyPond will automatically shorten ledger lines to avoid collisions.
% LedgerLineSpanner.minimum-length-fraction sets their minimum 
% length (i.e. smallest possible length) for such cases of potential 
% collision. It guarantees that ledger lines will always be at least 
% that wide. Its default setting is 0.25  (It should always be less 
% than or equal to the value of LedgerLineSpanner.length-fraction.)
%
% See the illustrations here:
% http://lilypond.1069038.n5.nabble.com/Widening-ledger-lines-by-overriding-LedgerLineSpanner-td162842.html#a162850

notes = {
  d4 e f g 
  c''' d''' e''' f'''
}

<<
\new Staff \with {
  instrumentName = "default "
} {
  \notes
}
\new Staff \with {
  instrumentName = "wider "
  \override LedgerLineSpanner.length-fraction = #0.45
  \override LedgerLineSpanner.minimum-length-fraction = #0.45
} {
  \notes
}
>>


