\version "2.22.2"

\header {
  texidoc = "
Many piano scores have the dynamics centered between the two staves. 
This snippet demonstrates how this was achieved with older versions of
LilyPond; the Dynamics context is now included by default (starting
with LilyPond 2.13.29), and does not require to be defined manually.

"
  doctitle = "Piano template with centered dynamics"
}
%% http://lsr.di.unimi.it/LSR/Item?id=357

global = {
  \key c \major
  \time 4/4
}

upper = \relative c'' {
  \clef treble
  a4 b c d
}

lower = \relative c {
  \clef bass
  a2 c
}

dynamics = {
  s2\fff\> s4 s\!\pp
}

pedal = {
  s2\sustainOn s\sustainOff
}

\score {
  \new PianoStaff = "PianoStaff_pf" <<
    \new Staff = "Staff_pfUpper" << \global \upper >>
    \new Dynamics = "Dynamics_pf" \dynamics
    \new Staff = "Staff_pfLower" << \global \lower >>
    \new Dynamics = "pedal" \pedal
  >>
  \layout { }
}

\score {
  \new PianoStaff = "PianoStaff_pf" <<
    \new Staff = "Staff_pfUpper" << \global \upper \dynamics \pedal >>
    \new Staff = "Staff_pfLower" << \global \lower \dynamics \pedal >>
  >>
  \midi { }
}



