\version "2.22.2"

\header {
  texidoc = "
Here is a way to substitute the \"denominator\" of the time signature
for the note duration corresponding to it. This creates a new Time
Signature Stencil, so it should work for all time signatures after
using the \\override function.

"
  doctitle = "Time signature with a note in the denominator instead of a number - changing TimeSignature stencil"
}
#(define-public (format-time-sig-note grob)
   (let* ((frac (ly:grob-property grob 'fraction))
          (num (if (pair? frac) (car frac) 4))
          (den (if (pair? frac) (cdr frac) 4))
          (m (markup #:override '(baseline-skip . 0.5)
                     #:center-column (#:number (number->string num)
                                               #:override '(style . default)
                                               #:note 
                                                 (ly:make-duration (1- (integer-length den)) 0 1) 
                                                 DOWN))))
     (grob-interpret-markup grob m)))

\new Staff {
  \override Staff.TimeSignature.stencil = #format-time-sig-note
  \time 3/8
  \relative c'' { c8 c c }
 }


