\version "2.22.2"

\header {
  texidoc = "
Draw curved staves as an alternative to arrows when staff's splited.

"
  doctitle = "Squeeze and split staff"
}
%% LSR : http://lsr.di.unimi.it/LSR/Snippet?id=1005
%% Credits: PPS on May 2015
%% Copyright: Frog Peak Music, used with permission
%% => http://lilypond.1069038.n5.nabble.com/Re-Message-to-David-Fuqua-td231104.html
%% => https://lists.gnu.org/archive/html/bug-lilypond/2020-03/msg00061.html

%Squeeze & split staff:
#(define-markup-command 
   (split-staff layout props 
     split-staff-length 
     split-staff-height-correction
     split-staff-height-position
     staff-staff-spacing-basic-distance)
   (number? number? number? number?)
   "Draw a curved staff with variable length & height starting from a point-stencil."
     (interpret-markup layout props
       (markup
         (#:path 0.1 
           `((moveto  0  0)  
             (curveto    
               ,split-staff-length    0   
               ,(* split-staff-length 0.5)  ,(+ (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 2)   
               ,(* split-staff-length 1.5)  ,(+ (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 2))
             (moveto  0  0)  
             (curveto    
               ,split-staff-length    0  
               ,(* split-staff-length 0.5)  ,(+ (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 1)   
               ,(* split-staff-length 1.5)  ,(+ (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 1))
             (moveto  0  0)  
             (curveto    
               ,split-staff-length    0   
               ,(* split-staff-length 0.5)  ,(+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance))  
               ,(* split-staff-length 1.5)  ,(+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)))
             (moveto  0  0)   
             (curveto    
               ,split-staff-length    0  
               ,(* split-staff-length 0.5)  ,(- (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 1)   
               ,(* split-staff-length 1.5)  ,(- (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 1))
             (moveto  0  0)  
             (curveto    
               ,split-staff-length    0   
               ,(* split-staff-length 0.5)  ,(- (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 2)   
               ,(* split-staff-length 1.5)  ,(- (+ split-staff-height-correction (* split-staff-height-position staff-staff-spacing-basic-distance)) 2)))))))

%Flip:
#(define-markup-command (flip layout props arg) (markup?) 
   (interpret-markup layout props
     (markup #:concat ( #:null #:scale (cons -1 1) #:line (arg)))))
%End flip.

#(define-markup-command 
   (squeeze-staff layout props 
     squeeze-staff-length 
     squeeze-staff-height-correction 
     squeeze-staff-height-position 
     staff-staff-spacing-basic-distance)
   (number? number? number? number?)
   "Draw a curved staff with variable length & height ending to a point-stencil."
   (interpret-markup layout props
     #{ 
       \markup\flip\split-staff 
            #squeeze-staff-length 
            #squeeze-staff-height-correction 
            #squeeze-staff-height-position 
            #staff-staff-spacing-basic-distance
     #}))

%End squeeze & split staff.


%%%%%%%%%%%%% Test %%%%%%%%%%%%%%
squezzeSplitStaff = 
\markup
\with-dimensions #'(0 . 0) #'(0 . 0)
\concat {
  \hspace #-.1
  \squeeze-staff #3 #0 #0 #0
  \hspace #-.3
  {
    \combine\split-staff #10 #0 #3 #12.5
    \combine\split-staff #10 #0 #2 #12.5
    \combine\split-staff #10 #0 #1 #12.5
    \combine\split-staff #10 #0 #0 #12.5
    \combine\split-staff #10 #0 #-1 #12.5
    \combine\split-staff #10 #0 #-2 #12.5
    \combine\split-staff #10 #0 #-3 #12.5
    \null
  }
}

squezzeSplitStaffBarLine = {
  \once \override Staff.BarLine.stencil =
    #(lambda (grob)
       (ly:stencil-combine-at-edge
        (ly:bar-line::print grob)
        X LEFT
        (grob-interpret-markup grob squezzeSplitStaff)
        -1.3))
}

\markup\column {
  "David Fuqua: excerpt from \"Slippy Surface\" with friendly permission of Frog Peak Music" 
  \vspace #1
  \fill-line {
    \override #'(thickness . 5)
    \override #'(box-padding . 2)
    \box
    \center-column  {
      "SOLO"
      \vspace #.5
      "continue as on previous page — make all sounds full of intent"
      "and energy — always explore the sounds as much as possible —"
      "try double (triple) stops with lower strings — perhaps with one"
      "string stopped, the other harmonic — make loud scrapes of stopped"
      "notes on the lower strings — explore sounds on the other side of"
      "the bridge momentarily — keep glissando going as a vigorous"
      "“ostinato” behavior — explore all sounds musical and non-musical"
      "this harmonic glissando technique can produce — stop approximately"
      "30 seconds after other players play their last figure — do not “telegraph”"
      "the end — stop without giving any warning"
    }
  }
  \vspace #1
}

\score {
  \new Staff = "main" {
     g'1\pp
      -\tweak script-priority #-100 \fermata 
      -\tweak extra-offset #'(-.5 . 1)^"30''" 
      \bar "" \squezzeSplitStaffBarLine
      \mark\markup
      \with-dimensions #'(0 . 0) #'(0 . 0)
      \translate #'(-12 . 26)
      \fontsize #-2
      \override #'(baseline-skip . 3)
      \center-column {
        "On cue"
        "glissando to next note"
        "over 10 seconds"
        \vspace #.5
        \override #'(thickness . 2)
        \draw-line #'(0 . 18.8)
        \vspace #-1
        \arrow-head #Y #DOWN ##f
      } 
    \override Score.Clef.space-alist.staff-bar = #'(extra-space . 3)
    \override Score.Clef.extra-offset = #'(1 . 0)
    \override Score.Clef.full-size-change = ##t
    \stopStaff s1 s s s \bar ""
    <<
      \new Staff  
        \with { 
          alignAboveContext = #"main" 
        } { 
            \clef G
            \mark\markup\bold "A"
            c''1\pp
            -\tweak script-priority #-100 \fermata 
            -\tweak extra-offset #'(-.5 . 1)^"30''" 
            \bar "" 
            \mark\markup\center-column {
              \fontsize #-2 "Cut off on cue"
              \vspace #.3
              \combine
              \arrow-head #Y #DOWN ##f 
              \override #'(thickness . 2) 
              \draw-line #'(0 . 6.4)
          }
          \stopStaff s1*4 \startStaff 
          \bar ""
          \once\override Staff.Clef.break-visibility = #all-visible
          \clef G
          f''16->[\ff 
          -\tweak X-offset #-3
          ^\markup\center-column {
            \fontsize #0 "On cue"
            \vspace #.3
            \combine
            \arrow-head #Y #DOWN ##f 
            \override #'(thickness . 2) 
            \draw-line #'(0 . 5)
          }
          f''->]
        }
      \new Staff  
        \with { 
          alignAboveContext = #"main" 
        } { 
            \mark\markup\bold "B"
            bes'1\fermata \pp \bar "" 
            \stopStaff s1*4 \startStaff 
            \bar ""
            \once\override Staff.Clef.break-visibility = #all-visible
            \clef G
            bes'16->[\ff bes'->]
        }
      \new Staff  
        \with { 
          alignAboveContext = #"main" 
        } { 
          \mark\markup\bold "C"
          aes'1\fermata \pp \bar "" 
          \stopStaff s1*4 \startStaff 
          \bar ""
          \once\override Staff.Clef.break-visibility = #all-visible
          \clef G
          e'16->[\ff e'->] 
        }
      { 
        \startStaff 
        \once\override Staff.Clef.break-visibility = #all-visible
        \clef G
        \mark\markup\bold "D"
        g'1\fermata \pp \bar "" 
        \stopStaff 
        s1*4 
        \startStaff 
        \bar ""
        \once\override Staff.Clef.break-visibility = #all-visible
        \clef G
        aes16->[\ff 
        -\tweak extra-offset #'(-20 . 0)
        ^\markup  
            \with-dimensions #'(0 . 0) #'(0 . 0)
            \center-column { 
              "30''" 
              \musicglyph "scripts.ufermata" 
              \italic "tacet"
            }
        aes->]
        \bar ""
        \tweak X-offset #2
        \tweak Y-offset #5
        \mark\markup
        \fontsize #-2
        \override #'(baseline-skip . 3)
        \left-column {
          \bold "Tacet al fine"
          \italic { 
            "hold instruments"
            "as if ready"
            "to play"
            "again"
          }
        }
      }
      \new Staff \with { 
        } { 
            \mark\markup\bold "E"
            f'1\fermata \pp \bar "" 
            \stopStaff s1*4 \startStaff 
            \bar ""
            \once\override Staff.Clef.break-visibility = #all-visible
            \clef F
            cis16->[\ff cis->]
        }
      \new Staff \with { 
        } { 
           \mark\markup\bold "F"
           e'1\fermata \pp  \bar "" 
           \stopStaff s1*4 \startStaff 
           \bar ""
           \once\override Staff.Clef.break-visibility = #all-visible
           \clef F
           g,16->[\ff g,->]
        }
      \new Staff \with { 
        } { 
          \mark\markup\bold "G"
          cis'1\fermata \pp   \bar "" 
          \stopStaff s1*4 \startStaff 
          \bar ""
          \once\override Staff.Clef.break-visibility = #all-visible
          \clef F
          c,16->[\ff c,->]
        }  
    >>
  }
  \layout {
    indent = 5
    \context {
      \Score
      \remove Mark_engraver
      \remove Staff_collecting_engraver
      %% For 2.23. remove Mark_tracking_translator and add it to Staff
      \remove Mark_tracking_translator
    }
    \context {
      \Staff
      \override VerticalAxisGroup.staff-staff-spacing = 
              #'((basic-distance . 6.626))  
      \consists Mark_engraver
      \consists Staff_collecting_engraver
      %% For 2.23. remove Mark_tracking_translator from Score and and add here
      \consists Mark_tracking_translator
      \remove Time_signature_engraver
    }
  }
}

\markup\fill-line {
  \override #'(baseline-skip . 7)
  \center-column {
    \italic "all cues are made by one player whom all the other players can see"
    \number \fontsize #8 "4"
  }
}



