\version "2.22.2"

\header {
  texidoc = "
By default, LilyPond directs all simultaneous cues into a single voice.
 Here is a solution that uses two voices for two different cues.

"
  doctitle = "Two cue voices"
}
cueDuringAlt =
#(define-music-function (what dir main-music)
   (string? ly:dir? ly:music?)
   (_i "Create a cue.

This function inserts the contents of quote @var{what} corresponding to
@var{main-music}, in a @code{CueVoice} context called @code{cueAlt} oriented by
@var{dir}.")
   (make-music 'QuoteMusic
               'element main-music
               'quoted-context-type 'CueVoice
               'quoted-context-id "cueAlt"
               'quoted-music-name what
               'quoted-voice-direction dir))


sop =
\new Voice = "sop" \relative c''' {
  \repeat unfold 8 g4
}

bass =
\new Voice = "bass" \relative c' {
  \repeat unfold 8 b4
}

first =
\new Voice \relative c' {
  c4 d c d
  \cueDuring #"sop" #UP
  \cueDuringAlt #"bass" #DOWN
  { \override MultiMeasureRest.staff-position = 0
    R1 }
}

\addQuote #"sop" \sop
\addQuote #"bass" \bass

{ \first }

{ \second }

