\version "2.22.2"

\header {
  texidoc = "
This snippet demonstrates how a (fairly simple) Scheme function may be
used similarly to @code{\\scaleDurations}, to automatically scale all
durations in a given music expression to make it fit inside a target
duration.

This is especially useful in polyphonic music where one voice has to
play a cadenza-like melody while other voices go on providing a regular
accompaniment in standard meter, as illustrated in this example from
Chopin’s Nocturne op.15 n°2.



"
  doctitle = "Automatic scaling of cadenza-like patterns in metered music"
}
%% Synthesized from multiple contributions on -user:
%% https://lists.gnu.org/archive/html/lilypond-user/2017-03/msg00500.html
%% https://lists.gnu.org/archive/html/lilypond-user/2014-07/msg00755.html

scaleToLength =
#(define-music-function (targetDur mus) (ly:duration? ly:music?)
   (let* ((real-len (ly:music-length mus))
          (mom (ly:duration-length targetDur))
          (factor (ly:moment-div mom real-len))
          (compressed (ly:music-compress mus factor)))
     #{ $compressed #}))

% from Chopin’s Nocturne op. 15 No. 2
\new PianoStaff <<
  \new Staff \relative {
    \time 2/4
    \key fis \major
    \teeny
    \scaleToLength 2 {
      b'8([ ais b) ais( a gis) a( gis a) gis( g fis) g( fis g)
      fis\( f e eis fis eis dis( eis fis) ais( gis eis fis dis gis)\)]
    }
  }
  \new Staff \relative {
    \clef bass
    \key fis \major
    << { s8 d4 } \\ { fis,8( d' <gis b> cis,) } >>
  }
>>



