\version "2.22.2"

\header {
  texidoc = "
Here is a way to replace all accidentals of any sort with an arbitrary
stencil (in this case, a markup). Alterations are defined as 1 for a
double-flat, -3/4 for a sesquiflat, etc.

"
  doctitle = "Replacing some accidentals with a user-defined stencil"
}
%% Originally contributed by vv on -user-fr:
% https://lists.gnu.org/archive/html/lilypond-user-fr/2020-03/msg00130.html
%% This causes a rather ugly collision on older LilyPond versions.

doubleSharp = \markup \concat {
  \raise #-.15 \sharp \sharp
}

\layout {
  \context {
    \Score
    \override Accidental.stencil =
    #(lambda (grob)
       (if (= 3/4
         (ly:pitch-alteration
          (ly:event-property
           (ly:grob-property
            (ly:grob-property grob 'cause)
            'cause) 'pitch)))
        (grob-interpret-markup
         grob (markup doubleSharp))
        (ly:accidental-interface::print grob)))
  }
}

\relative c'{ cisis cisih des }



