\version "2.22.2"

\header {
  texidoc = "
Sometimes you might want to show the basic beat in the tuplet number
text, i.e. @code{3:2 quarternote}, were @code{quarternote} is really a
note. The quick and dirty way is to manually set @code{\\override
TupletNumber #'text = #(markup #:italic \"3:2\" #:fontsize -5 #:note
\"4\" 1)}. However, then you'll have to change it as soon as you want
to use a 4/6 tuplet.


The better way is to write your own function for @code{#'text}, which
extracts the tuplet fraction from the tuplet object, formats the tuplet
text using the internal function and then appends the note you want. In
other words, we simply write a function, which wraps the internal
formatter function and modified its result:


#(define-public ((tuplet-number::append-note-wrapper function note)
grob)
  (let* ((txt (function grob)))
    (markup txt #:fontsize -5 #:note note UP)))


You simply pass the @qq{normal} formatter function (i.e.
@code{tuplet-number::calc-fraction-text} for @qq{3:2} or
@code{tuplet-number::calc-denominator-text} for @qq{3}) and the
duration of the note to append:


  \\override TupletNumber #'text = #(tuplet-number::append-note-wrapper
tuplet-number::calc-denominator-text \"8\")



"
  doctitle = "Appending a note to the tuplet text (using a scheme wrapper function)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=482

\paper { tagline = ##f }

% a formatter function, which is simply a wrapper around an existing 
% tuplet formatter function. It takes the value returned by the given
% function and appends a note of given length. 
#(define-public ((tuplet-number::append-note-wrapper function note) grob)
  (let ((txt (function grob)))
    (markup txt #:fontsize -5 #:note note UP)))
  
{
  % Tuplet text of the form:  2:3 quarternote; 
  % "2:3" is produced by tuplet-number::calc-fraction-text, we only append the quarter note
  \override TupletNumber.text = #(tuplet-number::append-note-wrapper tuplet-number::calc-fraction-text (ly:make-duration 2 0))
  \tuplet 3/2 {c'4 c' c'}
  \tuplet 3/2 {c' c' c'} 
  % Tuplet text of the form:  12:15 eighthnote, 2:3 eighthnote, etc.
  \override TupletNumber.text = #(tuplet-number::append-note-wrapper tuplet-number::calc-fraction-text (ly:make-duration 3 0))
  \tuplet 3/2 {c'8 c' c'}
  \tuplet 6/4 {c'4:8 c'4:8 c'4:8}
  \tuplet 3/2 {c'8 c'8 c'8}
  \tuplet 3/2 {c'4 c' c'}
  \tuplet 12/8 {c':16 c':16 c':16} 
  \break
  % Tuplet text of the form:  2 quarternote
  % We can use the same wrapper function, only that we now use 
  % calc-denominator-text, not the full calc-faction-text
  \override TupletNumber.text = #(tuplet-number::append-note-wrapper tuplet-number::calc-denominator-text (ly:make-duration 3 0))
  \tuplet 3/2 {c'8 c' c'}
  \tuplet 6/4 {c'4:8 c'4:8 c'4:8}
  \tuplet 3/2 {c'8 c'8 c'8}
  \tuplet 3/2 {c'4 c' c'}
  \tuplet 120/80 {c' c' c'}
}



