\version "2.22.2"

\header {
  texidoc = "
Some editions place the tremolo slash in the middle of the stem,
between the notes. Here is a way to achieve that.

"
  doctitle = "Tremolo slash at the stem midpoint"
}
% Contributed by V.V. on
% https://lists.gnu.org/archive/html/lilypond-user-fr/2020-03/msg00091.html

slashStemsOn = {
  \override StemTremolo.stencil =
  #(lambda (grob)
     (let* ((dir (ly:grob-property grob 'direction))
            (stem (ly:grob-parent grob X))
            (stem-stil (ly:stem::print stem))
            (stem-Y (ly:stencil-extent stem-stil Y))
            (stem-len (- (cdr stem-Y) (car stem-Y))))
       (ly:grob-set-property!
        grob 'beam-width
        (* 1.33 (ly:stem-tremolo::calc-width grob)))                 
       (ly:stencil-translate
        (ly:stem-tremolo::print grob)
        (cons (* -.33 dir)
              (* stem-len -.6 dir)))))
}

slashStemsOff = {
  \revert StemTremolo.stencil
}

{ 
  \slashStemsOn
  \stemUp
  <c' c''>2:8 <d' d''>: <e' e''>: <f' f''>:
  <g' g''>: <a' a''>: <b' b''>: <c'' c'''>:
  \stemDown
  <c' c''>2:8 <d' d''>: <e' e''>: <f' f''>:
  <g' g''>: <a' a''>: <b' b''>: <c'' c'''>:
  \stemUp
  <c' c'''>2:8 <d' d'''>: <e' e'''>: <f' f'''>:
  <g' g'''>: <a' a'''>: <b' b'''>: <c'' c''''>:
  \stemDown
  <c' c'''>2:8 <d' d'''>: <e' e'''>: <f' f'''>:
  <g' g'''>: <a' a'''>: <b' b'''>: <c'' c''''>:
}


