\version "2.22.2"

\header {
  texidoc = "
If you have lots of triplets and want to save some typing, you can
define your own \\triplet command. This is a simple illustration of how
to define your own Scheme function with embedded LilyPond code.

The example shows two possible implementations, one (\\triplet) where
you have to enclose the triplet  notes withing curly braces and one
(\\trip) that takes the following three music expressions and  combines
them into a triplet. The latter alternative saves even more typing,
since you don't need the  curly braces. On the other hand, it makes the
input file slightly harder to read and if you have a  triplet with more
than three notes (see the example) you need to add some curly braces to
get exactly three arguments to the function. 

"
  doctitle = "Shorthand for triplets"
}
%% http://lsr.di.unimi.it/LSR/Item?id=328

% Many many thanks to Mats for this useful snippet!

% First version, with a single argument, i.e. the 
% syntax is \triplet{ c d e }
triplet = #(define-music-function (music) (ly:music?)
  #{ \tuplet 3/2 $music #})


% Second version, with three arguments, i.e. the 
% syntax is \trip c d e 
trip = #(define-music-function (m1 m2 m3) 
  (ly:music? ly:music? ly:music?)
  #{ \tuplet 3/2 { $m1 $m2 $m3 } #})

\score{
  \relative c'{
    % Using \triplet
    c4 \triplet { d8 e f } g4 \triplet { f8 e d16 e } |
    % Using \trip. Note the last beat, where you have to 
    % add curly braces to get exactly three arguments to \trip
    c4 \trip d8 e f g4 \trip f8 e { d16 e } |
  }
}



