\version "2.22.2"

\header {
  texidoc = "
In mensural notation, you can find double time signatures, such as
mensural 6/4 followed by the classical time signature 3/2 (in ternary
white notation for instance). This scheme function, adapted from the 

http://lsr.di.unimi.it/LSR/Item?id=192 snippet, allows you to do so. 
The glyph argument is the name of the glyph in the Feta font. This
means that in fact this function can include any glyph. The
baseline-skip value can be adjusted to your needs, as well as the
font-size specifications.




"
  doctitle = "Combining a time signature glyph and a default time signature"
}
%% http://lsr.di.unimi.it/LSR/Item?id=725


#(define ((double-time-signature glyph a b) grob)
   (grob-interpret-markup grob
          (markup #:override '(baseline-skip . 2.5) #:number
                  (#:line ((markup (#:fontsize 4 #:musicglyph glyph))
                           (#:fontsize -1 #:column (a b)))))))

\relative c' {
  \override Score.TimeSignature.stencil =
      #(double-time-signature  "timesig.mensural64" "3" "2")
  \time 3/4
  c8 b c d e f g4 g g g4 a8 g f e d2. \bar "|."
}



