\version "2.22.2"

\header {
  texidoc = "
Occasionally, it is necessary to move a note's pitch to a certain staff
line or space, with no regard to the clef (e.g. to indicate percussion
on a non-percussive instrument.) The built-in
@code{Pitch_squash_engraver} does just that. This snippet provides two
Scheme shortcut functions, @code{\\squashTo} and @code{\\middleLine}.
Don't forget to include the correct engraver in the Voice context. 

"
  doctitle = "Forcing a note to a particular staff line"
}
%% http://lsr.di.unimi.it/LSR/Item?id=778

squashTo = #(define-music-function
  (position music)
  (number? ly:music?)
  #{
    \set squashedPosition = $position
    $music
    \unset squashedPosition
  #})

middleLine = #(define-music-function
  (music)
  (ly:music?)
  #{
    \squashTo #0 $music
  #})

\new Voice 
\with { \consists "Pitch_squash_engraver"} 
\relative c' {
  \clef treble
  \squashTo #1 { c4 d e f }
  \clef alto
  \squashTo #0 { c4 d e f }
  \clef bass
  \squashTo #-1 { c4 d e f }
  \middleLine { c4 d e f }
}



