\version "2.22.2"

\header {
  texidoc = "
<p>This macro allows you to get octaves from a sequence of single notes
(this is particularly useful in piano music).

<p>The function takes two arguments: the first one is a number (#1 adds
notes an octave above, #-1 an octave below, etc), the second one is the
music to deal with.

<p>Beware: the function can handle chords, but tends to reverse the
intervals.

"
  doctitle = "Adding automatic octaves to a melody"
}
%%  http://lsr.di.unimi.it/LSR/Item?id=445

%LSR by Jay Anderson.
%modyfied by Simon Albrecht on March 2014.
%=> http://lilypond.1069038.n5.nabble.com/LSR-445-error-td160662.html

#(define (octave-up m t)
 (let* ((octave (1- t))
      (new-note (ly:music-deep-copy m))
      (new-pitch (ly:make-pitch
        octave
        (ly:pitch-notename (ly:music-property m 'pitch))
        (ly:pitch-alteration (ly:music-property m 'pitch)))))
  (set! (ly:music-property new-note 'pitch) new-pitch)
  new-note))

#(define (octavize-chord elements t)
 (cond ((null? elements) elements)
     ((eq? (ly:music-property (car elements) 'name) 'NoteEvent)
       (cons (car elements)
             (cons (octave-up (car elements) t)
                   (octavize-chord (cdr elements) t))))
     (else (cons (car elements) (octavize-chord (cdr elements ) t)))))

#(define (octavize music t)
 (if (eq? (ly:music-property music 'name) 'EventChord)
       (ly:music-set-property! music 'elements (octavize-chord
(ly:music-property music 'elements) t)))
 music)

makeOctaves = #(define-music-function (arg mus) (integer? ly:music?)
 (music-map (lambda (x) (octavize x arg)) (event-chord-wrap! mus)))

 \relative c' {
   \time 3/8
   \key gis \minor
   \makeOctaves #1  { dis8( e dis')~ dis8.( cis16 b8} 
   \makeOctaves #-1 { ais' gis dis) cis( dis <dis gis'>) }
 }



