\version "2.22.2"

\header {
  texidoc = "
This snippet shows how to create fret diagrams with chord names but no
staff/staves, for a fret diagram which is not one of the predefined
fretboard diagrams i.e. with the fret diagrams specified using fret
diagram markup.


The first example in the \"Fret diagram markups\" section of the
\"Notation Reference\"
(http://lilypond.org/doc/v2.18/Documentation/6f/lily-b213fdb4.ly) is
defined using fret diagram markup, so I have used that example as the
basis for this snippet. Hence, this is also an example of how to remove
the staff (and all things in the staff) from the first example in the
\"Fret diagram markups\" section of the \"Notation reference\".


For more info, please see:


*
http://lilypond.org/doc/v2.18/Documentation/notation/common-notation-for-fretted-strings#predefined-fret-diagrams
(\"It
is common that both chord names and fret diagrams are displayed
together.\") and *
https://lists.gnu.org/archive/html/lilypond-user/2013-11/msg00080.html




"
  doctitle = "Creating fret diagrams with chord names but no staff/staves using fret diagram markup"
}
\storePredefinedDiagram
  #default-fret-table
  \chordmode { c }
  #guitar-tuning
  % "The diagram definition can be either a fret-diagram-terse
  % definition string..."
  #"x;3;2;o;1;o;"
  % "...or a fret-diagram-verbose marking list."
  % #'(
  %  (mute 6)
  %  (place-fret 5 3)
  %  (place-fret 4 2)
  %  (open 3)
  %  (place-fret 2 1)
  %  (open 1)
  % )


\storePredefinedDiagram
  #default-fret-table
  \chordmode { d:m }
  #guitar-tuning
  % Again, "either a fret-diagram-terse definition string..."
  #"x;x;o;2;3;1;"
  % "...or a fret-diagram-verbose marking list."
  % #'(
  %   (mute 6)
  %   (mute 5)
  %   (open 4)
  %   (place-fret 3 2)
  %   (place-fret 2 3)
  %   (place-fret 1 1)
  % )

myChords = \chordmode {
  c1 d:m
}

<<
  \new ChordNames {
    \myChords
  }
  \new FretBoards {
    \myChords
  }
>>



