\version "2.22.2"

\header {
  texidoc = "
This snippet shows how to create an 11-choir baroque lute tablature.
 It can be adapted to any kind of lute or tunings and with any type of
font (e.g. Bravura) for an old looking output.

 Midi output and worksheet for guitar transcriptions are also included. 

"
  doctitle = "Baroque lute tablature"
}
%% http://lsr.di.unimi.it/LSR/Item?id=920
%=> see also http://lilypond.1069038.n5.nabble.com/Ancient-tablature-repeat-barline-td159966.html#a159992
%=> see also http://lilypond.1069038.n5.nabble.com/Changing-Tuning-td163390.html#none

% by P.P.Schneider on June 2014.

%here starts the snippet:

\header { 
  tagline = #f
  composer = "Johann Michael Kühnel (ca.1665-after 1730)"
  % after the G minor Suite from Brno manuscripts, CZ-Bm Ms. sig. A.371, pages 95 to 98.
}

%%%%%%%%%%%%% cheat sheet : 11-choir baroque lute %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% High :
%  a 	b 	r 	d 	e 	f	 g	 h 	i	k
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  f' 	fis'	g'	gis'	a'	ais'	b'	c''	cis''	d''
%  d'	dis'	e'	f'	fis'	g'	gis'	a'	ais'	b'
%  a	ais	b	c'	cis'	d'	dis'	e'	f'	fis'
%  f	fis	g	gis	a	ais	b	c'	cis'	d'
%  d	dis	e	f	fis	g	gis	a	ais	b
%  a, 	ais,	b,	c	cis	d	dis	e	f	fis
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Low :
%  4	///a 	//a 	/a 	a 	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  c,	d,	e,	fis,	g,	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\parallelMusic #'(rhythm high medium low) {
  \time 3/4
  \key g\major
  % mes.0
    \partial 4. g8 s4 		|
    \partial 4. d'8 e' fis'	|
    \partial 4. r4.		|
    \partial 4. r4.		|  
  % mes.1
    \set Timing.measureLength = #(ly:make-moment 3/4) g8 s s2		|
    \set Timing.measureLength = #(ly:make-moment 3/4) r8 g' d' g' c' g'	|
    \set Timing.measureLength = #(ly:make-moment 3/4) s2.		|
    \set Timing.measureLength = #(ly:make-moment 3/4) g,2.		|
  % mes.2
    g4 g8 s4.		|
    b4 g8 b4 b8		|
    R2.			|
    g,2 fis,4		|
  % mes.3
    g8 s s2		|
    r8 g c' d' c' b	|
    R2.			|
    e,2.		|
  % mes.4
    g8 s s2		|
    r8 a fis a4 a8	|
    R2.			|
    fis,2 e,4		|
  % mes.5
    g8 s s2 		|
    r8 fis b c' b a	|
    R2.			|
    d,2. 		|
  % mes.6
    g8 s s2		|
    r8 g e g4 g8	|
    R2.			|
    e,2 d,4 		|
  % mes.7
    g8 s s2		|
    r8 e a b a g	|
    R2.			|
    c,2. 		|
  % mes.8
    g8 s s2 		|
    r8 fis d4. g8	|
    r4. c8 b,4 		|
    d,4. s8 s4 		|
  % mes.9
    g8 s g4. g16 s	|
    r8 a a4. g16 a 	|
    c4 d2		|
    R2.			|
  % mes.10
    g8 s s2		|
    g4. r		|
    R2.			|
    s8 g, fis,2		|
}

\score {
  <<
    \new RhythmicStaff = "Rhythm" { \rhythm }
    \new TabStaff = "High"
    \with {
      instrumentName = \markup { \fontsize #18 c }
      stringTunings = \stringTuning <a, d f a d' f'>
      fretLabels = \markuplist { 
        \column {  \vspace #.15 "a" }
        "b"
        \column {  \vspace #.15 "r" }
        "d" % optional \rotate #90 "d" 
        \column {  \vspace #.15 "e" }
        "f" 
        "g" 
        "h" 
        "i"
        "k"
      }
      \override TabNoteHead.extra-offset = #'(0 . .15) 
      \override VerticalAxisGroup.staff-staff-spacing = #'((padding . .5)) 
      \override TimeSignature.style = #'single-digit
      \override TimeSignature.X-offset = #-2
      \override TimeSignature.font-size = #3
      \revert TimeSignature.stencil
    }   
    << 
      \once\override Score.RehearsalMark.direction = #DOWN
      \once\override Score.RehearsalMark.self-alignment-X = #LEFT
      \once\override Score.RehearsalMark.break-align-symbols = #'(clef)
      \mark\markup "ouranta."
      \high \\ \medium 
    >>
    \new TabStaff = "Low"
    \with {
      \bar ""
      \remove "Staff_symbol_engraver"
      \override VerticalAxisGroup.staff-staff-spacing = #'(
                            (basic-distance . 2)
                            (padding . 2)) 
      stringTunings = \stringTuning <c,>
      fretLabels = \markuplist { 
        "4" \null 
        "///a" \null 
        "//a" \null
        "/a" 
%% With newer verions (tested wth 2.19.35) simple "a" is sufficient:
         \column { \vspace #.15 "a" }
      }
    }
    \low
  >>
  \layout {
    indent = 15
    \context {
      \RhythmicStaff
      \remove "Staff_symbol_engraver"
      \omit Clef                   	   
      \omit TimeSignature            
      \omit NoteHead
      \override Stem.length = #6
      fontSize = #-1
      \override VerticalAxisGroup.staff-staff-spacing =
        #'((basic-distance . 4)
           (minimum-distance . 3)
           (padding . 1))
      \stemUp 
      \autoBeamOff 
      \override Flag.stencil = #old-straight-flag
      \override Stem.thickness = #1.0
      \override Dots.extra-offset = #'(0.5 . 1)
      \override Stem.extra-offset = #'(0.5 . 0)
      \override Flag.extra-offset = #'(0.5 . 0)
    }
    \context {
      \TabStaff
      \omit Clef
      tablatureFormat = #fret-letter-tablature-format
    }
  }
}

% midi file :
\score {
  << \high \\ \medium \\ \low >>
  \midi { 
    \context {
      \Score 
      midiInstrument = #"acoustic guitar (nylon)"
    }
  }
}

%{ 
% worksheet :
\score {
  \new StaffGroup <<
    \new RhythmicStaff = "Rhythm" { \rhythm }
    \new TabStaff = "High"
    \with {
      stringTunings = \stringTuning <a, d f a d' f'>
      fretLabels = \markuplist { 
        \column {  \vspace #.15 "a" }
        "b"
        \column {  \vspace #.15 "r" }
        "d" % optional \rotate #90 "d" 
        \column {  \vspace #.15 "e" }
        "f" 
        "g" 
        "h" 
        "i"
        "k"
      }
      \override TabNoteHead.extra-offset = #'(0 . .15) 
      \override VerticalAxisGroup.staff-staff-spacing = #'((padding . .5)) 
      \override TimeSignature.style = #'single-digit
      \override TimeSignature.X-offset = #-2
      \override TimeSignature.font-size = #3
      \revert TimeSignature.stencil
    }
    << \high \\ \medium >>
    \new TabStaff = "Low"
    \with {
      \bar ""
      \remove "Staff_symbol_engraver"
      \override VerticalAxisGroup.staff-staff-spacing = #'(
                            (basic-distance . 2)
                            (padding . 2)) 
      stringTunings = \stringTuning <c,>
      fretLabels = \markuplist { 
        "4" \null 
        "///a" \null 
        "//a" \null
        "/a" 
         \column { \vspace #.15 "a" }
      }
    }
    \low
    \new GrandStaff <<
      \new Staff { 
        \clef "G_8"
        <<
          \context Voice = "High" { \voiceOne << \high >> }
          \context Voice = "Medium" { \voiceTwo << \medium >> } 
        >>
      }
      \new Staff { 
        \clef F 
        \low
      }
    >>
  >>
  \layout {
    indent = 0
    \context {
      \RhythmicStaff
      \remove "Staff_symbol_engraver"
      \omit Clef                   	   
      \omit TimeSignature            
      \omit NoteHead
      \override Stem.length = #6
      fontSize = #-1
      \override VerticalAxisGroup.staff-staff-spacing =
        #'((basic-distance . 4)
           (minimum-distance . 3)
           (padding . 1))
      \stemUp 
      \autoBeamOff 
      \override Flag.stencil = #old-straight-flag
      \override Stem.thickness = #1.0
      \override Dots.extra-offset = #'(0.5 . 1)
      \override Stem.extra-offset = #'(0.5 . 0)
      \override Flag.extra-offset = #'(0.5 . 0)
    }
    \context {
      \TabStaff
      \omit Clef
      tablatureFormat = #fret-letter-tablature-format
    }
  }
}
%}


