\version "2.22.2"

\header {
  texidoc = "
Implementation by Martin Straeten of the Schleifer ornament as used by
Johann Sebastian Bach, contributed to the user mailing list here. In
this case, it functions like a set of (always?) two grace notes, hence
using a modified grace note to represent it in LilyPond makes sense.



Code styling and user interface by Simon Albrecht 2024.



"
  doctitle = "„Schleifer“ ornament implemented as modified grace note"
}
schleiferMarkup = \markup {
  \large \halign #.2 \raise #0.0
  \combine
  \halign #.8 \musicglyph "scripts.prall"
  \rotate #140 \normalsize \raise #2.4 \musicglyph "flags.u3"
}
schleiferGrace =
#(define-music-function (note) (ly:music?)
   #{
     \grace {
       \once\override NoteHead.stencil = #ly:text-interface::print
       \once\override NoteHead.X-extent = #'(-2 . -0)
       \once\override NoteHead.text = \schleiferMarkup
       \once\omit Stem
       \once\omit Flag
       $note
     }
   #})

\relative {
  \time 3/8
  \partial 8
  \clef bass
  \key c \minor
  g8
  \schleiferGrace c es8. d16 c8
  c4
}
\addlyrics {
  Ich ha -- be ge -- nug
}
