\version "2.22.2"

\header {
  texidoc = "
This code can be used to add a circle around a tab note.  It's very
similar to the existing code to add a circle to notes on the staff.  
@code{\\once} can be removed if you want to add a string of annotated
circles. It can be used with @code{\\circle d8} The annotation is
useful add emphasis to a strummed note.

"
  doctitle = "Drawing circles around tab notes"
}
circle =
\once \override TabNoteHead.stencil =
  #(lambda (grob)
    (let* ((note (tab-note-head::print grob))
           (combo-stencil (circle-stencil note 0.1 0.3)))
      (ly:make-stencil (ly:stencil-expr combo-stencil)
        (ly:stencil-extent note X)
        (ly:stencil-extent note Y))))

electricGuitar = \relative c' {
  \override NoteHead.extra-spacing-width = #'(-2 . 2)
  \override StaffGrouper.staffgroup-staff-spacing.basic-distance = #15
  \circle e,,1\6
}


\score {
  \new StaffGroup
    \with {
      \consists "Instrument_name_engraver"
      instrumentName = "guitar"
    }
    <<
      \new Staff
        \with {
         \override StaffSymbol.staff-space = #(magstep 2)
        }
        { \clef "treble_8" \electricGuitar }
      \new TabStaff
        \with {
          stringTunings = #guitar-tuning
          \clef moderntab
        }
        \electricGuitar
    >>
  \layout {
    #(layout-set-staff-size 25)
    \context {
      \Voice
      \omit StringNumber
    }
  }
}

