\version "2.22.2"

\header {
  texidoc = "
The @code{\\whiteout} command puts a white background behind a given
markup text. 

This snippet shows an easy way to do this with any color. 

White text on black background can simply be created by
@code{\\with-color #white \\on-color #black}  

"
  doctitle = "Colored background for markup text"
}
% http://lsr.di.unimi.it/LSR/Item?u=1&id=969
% contributed by Klaus Blum

#(define-markup-command (on-color layout props color arg) (color? markup?)
   (let* ((stencil (interpret-markup layout props arg))
          (X-ext (ly:stencil-extent stencil X))
          (Y-ext (ly:stencil-extent stencil Y)))

     (ly:stencil-add 
       (stencil-with-color
         (ly:round-filled-box X-ext Y-ext 0)
         color)
       stencil)))

% Example usage:

\relative c' {
  c4^\markup { \on-color #green "pure" } d e f
  c4^\markup { \on-color #(rgb-color 1 0.8 0) \pad-markup #0.9 "padding" } d e f
  c4^\markup { \on-color #red \box "box" } d e f
  c4^\markup { \with-color #white \on-color #black \pad-markup #0.2 "b&w" } d e f
  c4^\markup { \on-color #blue \pad-markup #0.4 \whiteout "framed" } d e f
  c4^\markup { \with-color #magenta \on-color #blue \pad-markup #0.2 \bold "UGLY..." } d e f
  c4^\markup { 
    \rotate #1 
    \rotate #1 \on-color #(rgb-color 1 0 0.4) \pad-markup #0.1
    \rotate #1 \on-color #(rgb-color 1 0.2 0.2) \pad-markup #0.1
    \rotate #1 \on-color #(rgb-color 1 0.4 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.45 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.5 0) \pad-markup #0.1
    \rotate #1 \on-color #(rgb-color 1 0.55 0) \pad-markup #0.1
    \rotate #1 \on-color #(rgb-color 1 0.6 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.65 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.7 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.75 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.8 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.85 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.9 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 0.95 0) \pad-markup #0.1 
    \rotate #1 \on-color #(rgb-color 1 1 0)  "Crazy" } d e f
}



