\version "2.22.2"

\header {
  texidoc = "
In piano music parts it is customary to put the repeat counters between
the staves.  While it is rather straightforward to add the two percent
repeat engravers to the @code{Dynamics} context (which we use for
centering the counter numbers), it is non-trivial to get some vertical
whitespace above and below the digits for the double percent repeat
counter. 

"
  doctitle = "Percent repeat counters for piano music"
}
%% http://lsr.di.unimi.it/LSR/Item?id=883

\relative c' {
  \new PianoStaff <<
    \new Staff {
      \repeat percent 2 { e4 e e e } |
      \repeat percent 2 { 
        f4 f f f |
        d4 d d d 
      }
    }

    \new Dynamics {
      \set countPercentRepeats = ##t
      \repeat percent 2 { s1 } |
      \repeat percent 2 { s1*2 }
    }

    \new Staff {
      \repeat percent 2 { e4 e e e } |
      \repeat percent 2 { 
        f4 f f f |
        d4 d d d 
      } |
    }
  >>
}

\layout {
  \context {
    \Dynamics

    % Add percent repeat engravers.
    \consists "Percent_repeat_engraver"
    \consists "Double_percent_repeat_engraver"

    % Don't display the repeat glyphs.
    \override PercentRepeat.transparent = ##t
    \override DoublePercentRepeat.transparent = ##t

    % Center the counter numbers -- this is easy,
    % since the used feta digits are exactly two staff spaces high.
    \override PercentRepeatCounter.Y-offset = #-1
    \override DoublePercentRepeatCounter.Y-offset = #-1

    % Simply setting the `whiteout' property avoids a clash between
    % the counter and the barline, however, there is no vertical
    % padding which makes the result unsatisfactory.
    %
    % We thus use a hand-made stencil instead to white out 0.5 units
    % above and below the digit.  The code is based on the
    % `stencil-whiteout-box' function (in file `scm/stencil.scm').
    \override DoublePercentRepeatCounter.stencil =
      #(lambda (grob)
         (let* ((stencil (ly:text-interface::print grob))
                (x-ext (ly:stencil-extent stencil X))
                (y-ext (ly:stencil-extent stencil Y))
                (y-ext (interval-widen y-ext 0.5)))
           (ly:stencil-add
             (stencil-with-color (ly:round-filled-box x-ext y-ext 0.0)
                                 white)
             stencil)))
  }
}



