\version "2.22.2"

\header {
  texidoc = "
@code{staffLineLayoutFunction} is used to customize the default
vertical positions of notes on the staff. It can be used to create a
staff based on a whole tone scale, with a whole tone interval between
each adjacent note position (line or space).  For staves based on other
intervals simply change the number 2 in the formula to the number of
semitones in the interval you want.  (Staves based on whole tone scales
are used in certain alternative notation systems.  For a staff based on
semitones you can simply set @code{staffLineLayoutFunction} to
@code{ly:pitch-semitones}.)

"
  doctitle = "Staves based on a whole tone scale (or other interval)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=755

%LSR: Graham Breed gets the credit for this solution

scale = \relative c' {
  c4 d e fis 
  gis4 ais c2
  f,4 g a b 
  cis4 dis f2
  c,4 cis d dis 
  e4 f fis g
  gis4 a ais b
  c1
}

\new Staff \with {
  \remove "Accidental_engraver"
  staffLineLayoutFunction = #(lambda (p) (floor (/ (ly:pitch-semitones p) 2)))
}
{
  <<
    \scale
    \new NoteNames {
      \set printOctaveNames = ##f
      \scale
    }
  >>
}



