\version "2.22.2"

\header {
  texidoc = "
Problem: How to display chord diagrams on top of the score?

The chord diagrams description is a \\score block in a markup with
fill-line command, so that it can be centered.

There is also a scheme function in order to center the name of the
chords above the diagrams.

"
  doctitle = "Melody with chords. Chord diagrams described on top of the score."
}
\include "predefined-guitar-fretboards.ly"

#(define (text-interface::print-X-centered grob)
  (ly:stencil-aligned-to (ly:text-interface::print grob) X CENTER ))


diagrams = \chordmode {
  c s d:m s e s f s g s a:m s b:dim
}

melody = \relative c'' {
  c
}

my_chords = \chordmode {
  c
}


\header {
  title = "Title"
  composer = "Composer"
  tagline = ##f
}

\paper {
  markup-markup-spacing.basic-distance = 10
  markup-system-spacing.basic-distance = 15
}


\markup {
  \fill-line {
    \score {
      <<
        \new ChordNames << \diagrams >>
        \new FretBoards << \diagrams >>
      >>
      \layout {
        \context {
          \ChordNames
          \override ChordName.stencil = #text-interface::print-X-centered
        }
        \context {
          \FretBoards
          \override FretBoard.align-dir = #CENTER
        }
      }
    }
  }
}


\score {
  <<
    \new ChordNames \my_chords
    \new Staff \melody
  >>
}



