\version "2.22.2"

\header {
  texidoc = "
If you want to specify the number of measures per line, this Scheme
engraver provides an alternative to inserting @code{\\break}s within
your file or using an extra voice for line breaks.  This is a
convenient method for music that changes meter, and a quick way to
duplicate the layout of a model.


The function takes a list of numbers describing a pattern which will
repeat throughout the score.  The example shows how to specify four
measures per line.  More numbers in the list will create a pattern of
greater complexity.  For example, @code{\\consists
#(bars-per-line-engraver '(2 3 4))} defines lines of two, three, and
four bars in succession.  If the lengths add up to the length of the
score, you've specified the length of each line individually.


The spacing engine will sometimes override your specifications if a
line is too cramped as a result.  To insist on your pattern, use the
override of @code{'line-break-permission} which is commented out in the
example. 

"
  doctitle = "Specifying number of measures per line"
}
%% http://lsr.di.unimi.it/LSR/Item?id=838

%LSR completed by P.P.Schneider on Feb. 2014 for v2.18

#(define ((bars-per-line-engraver bar-list) context)
  (let* ((working-copy bar-list)
         (total (1+ (car working-copy))))
    `((acknowledgers
       (paper-column-interface
        . ,(lambda (engraver grob source-engraver)
             (let ((internal-bar (ly:context-property context 'internalBarNumber)))
               (if (and (pair? working-copy)
                        (= (remainder internal-bar total) 0)
                        (eq? #t (ly:grob-property grob 'non-musical)))
                   (begin
                     (set! (ly:grob-property grob 'line-break-permission) 'force)
                     (if (null? (cdr working-copy))
                         (set! working-copy bar-list)
                         (begin
                           (set! working-copy (cdr working-copy))))
                           (set! total (+ total (car working-copy))))))))))))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% EXAMPLE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

myMusic = \relative c' {
  \repeat unfold 4 {
    \time 5/4
    c4 c c c c
    \time 3/4
    c c c
    \time 3/2
    c2 c c
  }
}

\score {
  \new Staff { 
    \once\override Score.RehearsalMark.self-alignment-X = #LEFT
    \mark\markup\small\italic "4 measures per line:"
    \myMusic 
  }
  \layout {
    \context {
      \Score
      %use the line below to insist on your layout
      %\override NonMusicalPaperColumn.line-break-permission = ##f
      \consists #(bars-per-line-engraver '(4))
    }
  }
}
\score {
  \new Staff { 
    \once \override Score.RehearsalMark.self-alignment-X = #LEFT
    \mark\markup\small\italic "6 measures per line:"
    \myMusic 
  }
  \layout {
    \context {
      \Score
      %use the line below to insist on your layout
      %\override NonMusicalPaperColumn.line-break-permission = ##f
      \consists #(bars-per-line-engraver '(6))
    }
  }
}

\paper { tagline = ##f }

