\version "2.22.2"

\header {
  texidoc = "
I wanted to skew a markup analog to SVG's functionality
https://www.w3.org/TR/SVG/coords.html#InterfaceSVGTransform. The
purpose was to mimick a shadow.

"
  doctitle = "Skew Markup"
}
\paper { tagline = ##f }

aaa = \markup \filled-box #'(10 . 30) #'(10 . 20) #0

%% skew markup
%% p ... scaling factor in y-direction
%% q ... extension factor in y-direction
%% arg ... markup

%% rotate markup 45° and scale it with (1 . p) 
%% now x- and y-axes are compressed with different scales
%% rotation back with arctan(p) 
%% scale with #(cons (/ 1 l) (/ p l))

#(define-markup-command (skew-x layout props p arg q)
   (number? markup? number? )
   (let* (
           (p2 (* p p))
           (p2h (/ p2 2))
           (ll (+ .5 p2h))
           (l (sqrt ll))
           (xtan (atan p))
           (winkel (/ (* -1 (* xtan 180)) PI))
           )
     (interpret-markup layout props
                       #{
                         \markup \scale #(cons (/ 1 l) (/ p l)) \rotate #winkel
                         \scale #`(1 . ,p) \rotate #45 \scale #`(1 . ,q) $arg
                       #}
                       )))

\markup \combine \with-color #(x11-color 'MidnightBlue) \aaa
\translate #'(6.1 . 6.35)
\skew-x #.2 \with-color #(x11-color 'snow4) \aaa #3
