\version "2.22.2"

\header {
  texidoc = "
Here's how to put a markup – such as a sul tasto reminder – over the
clefs.

"
  doctitle = "Markup on clef"
}
%% http://lsr.di.unimi.it/LSR/Item?id=1086
%% Discussion => http://lilypond.1069038.n5.nabble.com/Markup-on-clef-possible-td219968.html
%% See also => http://lilypond.1069038.n5.nabble.com/Align-text-above-clef-td216678.html
%% Credit: PPS on Feb. 2019

STclef = {
  \once\override Staff.Clef.stencil = 
    #(lambda (grob) 
       (let ((glyph (ly:grob-property grob 'glyph-name))) 
               (cond
                ((equal? glyph "clefs.G")  
                   (grob-interpret-markup grob #{ 
                      \markup 
                      \translate #'(0 . 5.5)
                      \override #'(baseline-skip . 5.5)
                      \column { "ST" \musicglyph "clefs.G" } #}))
                ((equal? glyph "clefs.F")  
                  (grob-interpret-markup grob #{ 
                      \markup 
                      \translate #'(0 . 2)
                      \override #'(baseline-skip . 2)
                      \column { "ST" \musicglyph "clefs.F" } #}))
                (else (ly:clef::print grob)))))
}

%% Test:
\new StaffGroup <<
  \new Staff 
    \with { instrumentName = "Violin" }
    \relative c' { \STclef \clef G a' b c d \break b c a c }
  \new Staff 
    \with { instrumentName = "Cello" }
    \relative c, { \STclef \clef F a' b c d \break b c a c }
>>

\paper { tagline = ##f }

