\version "2.22.2"

\header {
  texidoc = "
Time signatures with denominators that are not powers of two can be
used easily in LilyPond, by setting the time signatures you want and
scaling the rhythmic value by the appropriate amount.

The scaling fraction involves a denominator that is the same as that of
the time signature and a numerator that is of the appropriate
fractional relationship for the time signature. For instance, since
seven divisions of the whole note would be written as with seven notes
resembling quarters, the scaling fraction for seventh measures would be
4/7.

LilyPond correctly produces MIDI files for these time signatures;
uncomment the \\midi line to check this.

"
  doctitle = "Irrational time signatures for metric modulation"
}
%% http://lsr.di.unimi.it/LSR/Item?id=552

% Warnings may be suppressed using 'ly:expect-warning'
% Or use the here defined 'suppressWarning'-function, working since 2.20.
   
   suppressWarning =
   #(define-void-function (amount message)(number? string?)
     (for-each
       (lambda (warning)
         (ly:expect-warning message))
       (iota amount 1 1)))
       
   \suppressWarning 3 "strange time signature found"

metrmods = \relative c' {
  \time 4/4
  \tempo 4 = 60
  fis4 fis fis fis
  \time 2/6
  g4*2/3 g |
  g4*2/3 g |
  \time 4/5
  as4*4/5 as as as8*4/5 g |
  \tuplet 3/2 { as4*4/5 as as } as4*4/5 as8*4/5 g |
  \time 3/7
  fis4*4/7 fis fis |
  fis4*4/7 fis fis |
}

\score {
  \metrmods
  % uncomment to check MIDI output.
  % \midi { }
  \layout { }
}



