\version "2.22.2"

\header {
  texidoc = "
If you have a choir score, or an orchestral score, where some voices
are quiet for a long time, you might want to hide staves containing
nothing (or only multi-measure rests). By default, LilyPond shows all
staves, even if they only contain rests. To change this into what is
sometimes called a \"French Score\" style, simply add the
@code{\\RemoveEmptyStaffContext} variable, in a @code{\\context} block,
to your @code{\\layout}.


The first system would still show all staves for all voices. To force
this setting to also apply to the first system of a score, set
@code{remove-first} of @code{VerticalAxisGroup} to @code{#t}.


If only one staff is displayed, the choir or the @code{StaffGroup}
bracket would also be hidden, so you will probably need to set
@code{collapse-height} of @code{SystemStartBracket} to value 1 (or
anything smaller than 5).


If you have some voices where you still want to display all (even
empty) staves, you need to set the @code{remove-empty} property of the
@code{VerticalAxisGroup }to @code{#t} for that one staff only. You can
do this in the @code{\\with} section of the staff (in this example, the
alto staff will never erase empty lines, while the soprano staff will).


"
  doctitle = "Hiding staves with rests only (for some/all voices)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=307

%here starts the snippet:

sop = \relative c'' {
  R1*2 |\break 
  c4 c c c | R1 |\break
  R1*2 | \break
  R1*2 |\break 
  c4 c c c | R1 \bar"|."
}

alt = \relative c'' {
  g4 g g g | R1 | \break |
  R1*2 | \break
  R1*2 | \break
  g4 g g g | R1 | \break |
  g4 g g g | R1 \bar"|."
}

\layout {
  \context { 
    % add the RemoveEmptyStaffContext that erases rest-only staves
    \Staff \RemoveEmptyStaves 
  }
  \context {
    \Score
    % Remove all-rest staves also in the first system
    \override VerticalAxisGroup.remove-first = ##t
    % If only one non-empty staff in a system exists, still print the starting bar
    \override SystemStartBar.collapse-height = #1
  }
  \context {
    \ChoirStaff 
    % If only one non-empty staff in a system exists, still print the bracket
    \override SystemStartBracket.collapse-height = #1
    \override SystemStartBar.collapse-height = #1
  }
}

\score{
  \context ChoirStaff <<
    \context Staff=soprano <<
      \sop
      \set Staff.shortInstrumentName = "S"
    >>
    % never remove empty staves from the alto staff:
    \context Staff=alto \with { \override VerticalAxisGroup.remove-empty = ##f }
    <<
      \alt
      \set Staff.shortInstrumentName = "A"
    >>
  >>
}

\paper { tagline = ##f }


