\version "2.22.2"

\header {
  texidoc = "
In polyphonic notation, many voices can share a staff: In this
situation, the accidentals and staff are shared, but the stems, slurs,
beams, etc., are private to each voice. Hence, engravers should be
grouped. The engravers for note head, stems, slurs, etc., go into a
group called @qq{Voice context}, while the engravers for key,
accidental, bar, etc., go into a group called @qq{Staff context}. In
the case of polyphony, a single Staff context contains more than one
Voice context. Similarly, more Staff contexts can be put into a single
Score context.  

"
  doctitle = "Grouping contexts"
}
%% http://lsr.di.unimi.it/LSR/Item?id=108

\layout {
  indent = 0
}

topVoice = \relative c' {
  \key d\major
  es8([ g] a[ fis])
  b4
  b16[-. b-. b-. cis-.]
  d4->
}

botVoice = \relative c' {
  \key d\major
  c8[( f] b[ a)]
  es4
  es16[-. es-. es-. fis-.]
  b4->
}

hoom = \relative c {
  \key d \major
  \clef bass
  g8-. r
  r4
  fis8-.
  r8
  r4
  b'4->
}

pah = \relative c' {
  r8 b-.
  r4
  r8 g8-.
  r16 g-. r8
  \clef treble
  fis'4->
}


\score {
  \context Staff << \topVoice \\ \botVoice >>
}


\score {
  << 
    \new Staff << \topVoice \\ \botVoice >>
    \new Staff << \pah \\ \hoom >>
  >>
}

\paper { tagline = ##f }

