\version "2.22.2"

\header {
  texidoc = "
This snippet shows how to draw a bracket around objects on different
staves.


Syntax is


  ^\\markup\\openBracket #width #height

and


  ^\\markup\\closeBracket #width #height

"
  doctitle = "Draw a bracket spanning multiple staves"
}
%% http://lsr.di.unimi.it/LSR/Item?id=957

%=> http://lilypond-french-users.1298960.n2.nabble.com/Imprimer-un-crochet-debut-et-un-crochet-fin-sur-un-systeme-de-portees-tc7581854.html

% modified by P.P.Schneider on January 2016.
% => http://www.lilypondforum.de/index.php?topic=434.msg11931#msg11931

%%% SNIPPET: %%%

\header { tagline = ##f }

#(define-markup-command (openBracket layout props height) (number?)
  (interpret-markup layout props
    (markup #:line (#:with-dimensions (cons 0 0) (cons 0 0)
      (#:path 0.25
        (list (list (quote moveto) 0 0)
        (list (quote lineto) -1 0)
        (list (quote lineto) -1 (* height -1))
        (list (quote lineto) 0 (* height -1))))))))

#(define-markup-command (closeBracket layout props height) (number?)
  (interpret-markup layout props
    (markup #:line (#:with-dimensions (cons 0 0) (cons 0 0)
      (#:path 0.25
        (list (list (quote moveto) 1.3 0)
        (list (quote lineto) 2.3 0)
        (list (quote lineto) 2.3 (* height -1))
        (list (quote lineto) 1.3 (* height -1))))))))

\new PianoStaff <<
  \new Staff \relative c'' {
    a^\markup\openBracket #14 
    c'^\markup\closeBracket #16.5 
  }
  \new Staff { \clef F c' c' }
>>

%LSR prevent clipping
\markup \vspace #1

%%% SNIPET END %%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% OLD %%%%

%{
%%% by P.P.Schneider on November 2014.

#(define-markup-command (flip layout props myGrob)
  (markup?) 
    (interpret-markup layout props
      (markup #:concat (#:null #:scale (cons -1 1) #:line (myGrob)))))

#(define-markup-command (crochet layout props myBracketHeight) (number?)
  (interpret-markup layout props
    (markup #:line (#:with-dimensions (cons -1 0) (cons 0 2)
      (#:path 0.25
        (list (list (quote moveto) 0 1.5)
        (list (quote lineto) -2 1.5)
        (list (quote lineto) -2 (* myBracketHeight -1))
        (list (quote lineto) 0 (* myBracketHeight -1))))))))

global = {
  \key b\minor
  \time 3/4 
  \set Score.currentBarNumber = #243
  \bar ""
  \mark\markup\box "M"
}

\score {
  <<
    \new Voice = "Baryton" {
      \global
      \clef F
      <>^\markup\crochet #30 
      _\markup\tiny { 
        \override #'(baseline-skip . 2)\center-column {
          "Suggested" "cut at" "bar 275*" 
        }
      }
      r4 r c' 
      c'-\tweak X-offset #1
      ^\markup\flip\crochet #32 c' s
    }
    \new Lyrics \lyricsto "Baryton" {
      I
    }
    \new Lyrics \lyricsto "Baryton" {
      \markup\italic So
    }
    \new PianoStaff <<
      \new Staff {
        \global
        g''4.( a''8) fis''4-. fis'' fis'' s
      }
      \new Staff {
        \global
        \clef F
        << { r4 <c' d'> q c' c' s } \\ { a2. d } >>
      }
    >>
  >>
  \layout {
    ragged-right = ##f
    \context {
      \Score
      \omit TimeSignature
    }
  }
}
%}



