\version "2.22.2"

\header {
  texidoc = "
Instead of having to type the same customization commands every time
you need to use a particular type of staff, you can define a custom
staff context and use it instead. For example, instead of:

@code{\\new Staff \\with @{ ... @}}

You would use:
 
@code{\\new MyCustomStaff}

A custom staff context can have any customizations that you would use
in a Staff's \\with block. Note that the custom staff's definition can
be saved in a file that you @code{\\include}, so you do not have to
re-create it every time it is needed. 

"
  doctitle = "Defining a Custom Staff Context"
}
%% http://lsr.di.unimi.it/LSR/Item?id=979 (formerly id=882)

% DEFINE A CUSTOM STAFF CONTEXT FOR "LAYOUT"
\layout {
  \context {
    % make a copy of the standard Staff context
    \Staff
    % give this custom context a name of your choice
    \name MyCustomStaff
    % tell LilyPond that commands that work in a standard
    % Staff context should also work in this custom context
    \alias Staff
    % add customizations, these are just examples,
    % they can be anything that can go in a staff's \with block
    \consists "Pitch_squash_engraver"
    squashedPosition = #0
    \override NoteHead.style = #'slash
    \override Stem.transparent = ##t
    \override Flag.transparent = ##t
  }
  % define which "parent" contexts will accept this custom context as a "child"
  \context { \Score      \accepts MyCustomStaff }
  \context { \ChoirStaff \accepts MyCustomStaff }
  \context { \GrandStaff \accepts MyCustomStaff }
  \context { \PianoStaff \accepts MyCustomStaff }
  \context { \StaffGroup \accepts MyCustomStaff }
}

% DEFINE THE CUSTOM STAFF CONTEXT FOR "MIDI" TOO
% to avoid warnings the context has to be defined for each type of output
\midi {
  \context {
    \Staff
    \name MyCustomStaff
    \alias Staff
    % the customizations are not needed for midi 
    % since they are for visual output only
  }
  \context { \Score      \accepts MyCustomStaff }
  \context { \ChoirStaff \accepts MyCustomStaff }
  \context { \GrandStaff \accepts MyCustomStaff }
  \context { \PianoStaff \accepts MyCustomStaff }
  \context { \StaffGroup \accepts MyCustomStaff }
}

% EXAMPLE
\score {
  <<
    \new Staff {
      c' d' e' f'
    }
    \new MyCustomStaff {
      c' d' e' f'
    }
  >>
  \layout { }
  \midi { }
}


