\version "2.22.2"

\header {
  texidoc = "
For critical editions, objects like clefs, key or time signatures
sometimes need to be written in parentheses to indicate they are
missing from the autograph.  This can be achieved by simply wrapping
the @code{bracketify-stencil} function around the object's stencil
function.  By using @code{\\once \\override}, the effect can be applied
to just one clef/key/time signature; by using @code{\\override} it
applies to the whole piece.

"
  doctitle = "Clef, key and time signature in square brackets"
}
%% http://lsr.di.unimi.it/LSR/Item?id=647


\layout { ragged-right = ##t }

\relative c'' {
  % Use \once \override if you only want the object immediately following
  % to be in brackets.
  \override Staff.Clef.stencil = #(lambda (grob)
    (bracketify-stencil (ly:clef::print grob) Y 0.1 0.2 0.1))
  \override Staff.TimeSignature.stencil = #(lambda (grob)
    (bracketify-stencil (ly:time-signature::print grob) Y 0.1 0.2 0.1))
  \override Staff.KeySignature.stencil = #(lambda (grob)
    (bracketify-stencil (ly:key-signature-interface::print grob) Y 0.1 0.2 0.1))
  \time 2/4
  \key cis \minor
  a4 b8 cis \break
  \clef "bass"
  c,,2
}



