\version "2.22.2"

\header {
  texidoc = "
I have encountered music in the wild where the primary voice is joined
by a bunch of sub-voices.  In this particular instance, this is notated
as a set of chords, where the note head of the primary voice is in a
normal font, but the note heads for the other voices are in a smaller
font. My solution is to make a scheme music function which modifies all
chords that it is given such that the first pitch specified in the
chord uses the normal font, and all other pitches are tweaked to use a
font size two smaller.

Problems: This does not properly resize accidentals attached to the
smaller note heads. 

"
  doctitle = "Chords with one normal note head and multiple small note heads"
}
%% http://lsr.di.unimi.it/LSR/Item?id=538

smallChordNotes = #(define-music-function (parser location loc) (ly:music?)
   (music-map 
     (lambda (x)
       (if (eq? (ly:music-property x 'name) 'EventChord)
           (let ((copy (ly:music-deep-copy x)))
              (let ((l_elements (ly:music-property copy 'elements)))
                 (if (pair? l_elements)
                     (let ((elements (cdr l_elements)))
                        (while (pair? elements)
                           (ly:music-set-property! (first elements) 'tweaks
                              (acons 'font-size -3 
                                     (ly:music-property (car elements) 'tweaks)))
                           (set! elements (cdr elements))))
                    copy)
                 copy))
           x))
     loc))

\relative c' \smallChordNotes {
   \repeat volta 2 { 
     <f a c>4 <a f c'> <c f, a> <c b f>
     <c c'>4 <b b'> <a a'> g
     <b g>8( <a fis>) <g e b'>4. q8 q4 
     <fis d d'>4. q8 q2  
   }
   <g g e'>4 q <e e c'> q <e e b>2 q~ q2.
   \bar "|." 
}



