\version "2.22.2"

\header {
  texidoc = "
The code in this snippet defines a new command @code{\\bracketAcc} to
put brackets around an accidental.  It also works in chords.

Note that you have to use a trailing ‘@code{?}’ character after the
note in the input to enforce a cautionary accidental.

"
  doctitle = "Bracketed accidentals"
}
% Based on code from Abraham Lee
%
% https://lists.gnu.org/archive/html/lilypond-user/2016-11/msg00928.html

#(define make-bracketed
   (grob-transformer
    'stencil
    (lambda (grob orig)
      (let* ((paren-stil (grob-interpret-markup
                          grob 
                          (markup #:musicglyph "accidentals.leftparen")))
             (ext (ly:stencil-extent paren-stil Y))
             (stil (ly:accidental-interface::print grob))
             (thick (ly:output-def-lookup (ly:grob-layout grob)
                                          'line-thickness 0.1))
             (padding thick)
             (protrusion (* 2.5 thick))
             (lb (ly:bracket Y ext thick protrusion))
             (rb (ly:bracket Y ext thick (- protrusion))))
        (set! stil (ly:stencil-combine-at-edge stil X 1 rb padding))
        (set! stil (ly:stencil-combine-at-edge stil X -1 lb padding))
        stil))))

bracketAcc = 
  \tweak AccidentalCautionary.parenthesized ##f
  \tweak AccidentalCautionary.stencil #make-bracketed \etc

{
    <c'' es''? fis''>1
    <c'' \bracketAcc es''? fis''>1
}

\paper { tagline = ##f }

