\version "2.22.2"

\header {
  texidoc = "
When editing a piece of music, it can be helpful to see when the
directions of slurs, stems, or other grobs have been manually set (as
opposed to being automatically set by LilyPond).  This snippet changes
the color of grobs when their direction has been manually set.  Red
indicates up, and blue indicates down.  It can be applied to all grobs,
or just to certain types of grob (i.e. just @code{Slur}, or just
@code{Slur} and @code{TextScript}).

"
  doctitle = "Automatically coloring grobs to indicate when their direction has been manually set"
}
%% http://lsr.di.unimi.it/LSR/Item?u=1&id=889

%LSR thanks to David Kastrup for this code snippet.
%=> http://lilypond.1069038.n5.nabble.com/Catch-direction-operators-td151552i20.html

\paper { tagline = ##f }

colorizeDir =
#(define-music-function (item)
   (symbol-list-or-music?)
   (define (grob-colorize-dir grob)
     (let ((ev (event-cause grob)))
       (case (and ev (ly:event-property ev 'direction))
         ((1) red)
         ((-1) blue)
         (else '()))))
   ;; updaters note for 2.20:
   ;; \tweak was changed in 2.20, thus switching to \override
   ;; (\override works for 2.18 as well)
   #{ \override $item . color = #grob-colorize-dir #})

mapList =
#(define-music-function (fun lst)
   (ly:music-function? list?)
   #{ $@(map (lambda (s) #{ $fun $s #}) lst) #})

music =
{
  a2-( b)
  a^( b)
  a''_( b)

  c''-3\4-"xy"
  c''_3^\4^"xy"
  c''^3_\4_"xy"
}

% only color Slur and TextScript grobs
\new Voice \with { \mapList #colorizeDir Slur.TextScript }
{ \music }

% color all grobs
\new Voice \with { \mapList #colorizeDir #(map car all-grob-descriptions) }
{ \music }



