\version "2.22.2"

\header {
  texidoc = "
When preparing song sheets, it's sometimes useful to have the lyrics of
all the verses inside the score, correctly lined up to the notes.
However, this makes it easy for the singer to mix up verses --
especially when changing systems. A common solution is to alternate the
display properties of the lyric lines. This snippet demonstrates how to
use such an approach in LilyPond.



"
  doctitle = "Alternate lyrics context for song sheets (alternate)"
}
% Code originally written by dak
%
%   https://lists.gnu.org/archive/html/lilypond-user/2012-07/msg00258.html
%
% Slightly adjusted by wl
%
% See also http://lsr.di.unimi.it/LSR/Item?id=641

#(set-global-staff-size 18)


#(define (lyricswitch context)
   "This engraver injects a '\\with' block if it finds a 'Lyrics'
context and its internal counter is even."
   (let ((cnt 0))
     (make-engraver
      (listeners
       ((AnnounceNewContext translator ev)
        (when (eq? (ly:context-name
                    (ly:event-property ev 'context)) 'Lyrics)
          (set! cnt (1+ cnt))
          (when (even? cnt)
            (ly:context-mod-apply!
             (ly:event-property ev 'context)
             #{
	       \with {
                 \override StanzaNumber.font-series = #'normal
                 \override LyricText.font-shape = #'italic
                 \override LyricText.color = #(x11-color 'grey20)
                 \override VerticalAxisGroup.nonstaff-nonstaff-spacing =
                             #'((basic-distance . 0)
                                (minimum-distance . 4) ; make a gap
                                (padding . 0.2)
                                (stretchability . 0))
	       }
             #} ))))))))


%% Implement an alternate lyric context.
myLayout =
\layout {
  \context {
    \Lyrics
    \override LyricText.font-size = #-1
  }

  \context {
    \Score
    \consists #lyricswitch
  }

  \context {
    \StaffGroup
    \consists #lyricswitch
  }

  \context {
    \ChoirStaff
    \consists #lyricswitch
  }
}


%%%%%%%%%%%% test %%%%%%%%%%%%%%%%%%%

mus = \relative c' \repeat unfold 3 { c4 c c c \break }

lyrOne = {
  \set stanza = "1. "
  \lyricmode { \repeat unfold 11 { bla -- } bla }
}

lyrTwo = {
  \set stanza = "2. "
  \lyricmode { \repeat unfold 11 { blub -- } blub }
}

lyrThree = {
  \set stanza = "3. "
  \lyricmode { \repeat unfold 11 { foo -- } foo }
}

lyrFour = {
  \set stanza = "4. "
  \lyricmode { \repeat unfold 11 { bar -- } bar }
}

lyrFive = {
  \set stanza = "5. "
  \lyricmode { \repeat unfold 11 { baz -- } baz }
}

lyrSix = {
  \set stanza = "6. "
  \lyricmode { \repeat unfold 11 { har -- } har }
}


\score {
  \new ChoirStaff <<
    \new Staff <<
      \new Voice = "mus" \mus

      \new Lyrics \lyricsto "mus" \lyrOne
      \new Lyrics \lyricsto "mus" \lyrTwo
      \new Lyrics \lyricsto "mus" \lyrThree
      \new Lyrics \lyricsto "mus" \lyrFour
      \new Lyrics \lyricsto "mus" \lyrFive
      \new Lyrics \lyricsto "mus" \lyrSix
    >>

    \new Voice = "mus" \mus
  >>

  \layout { \myLayout }
}


\paper {
  system-system-spacing.basic-distance = 20
  ragged-last-bottom = ##t
  tagline = ##f
}

