\version "2.22.2"

\header {
  texidoc = "
Double and triple tonguing indications can be added to notes by
tweaking the appearance of staccato articulations.

"
  doctitle = "Adding double and triple tonguing indications for woodwind"
}
%% http://lsr.di.unimi.it/LSR/Item?id=772

tongue =
#(define-music-function (dots) (integer?)
  #{
    \tweak stencil
      #(lambda (grob)
        (let ((stil (ly:script-interface::print grob)))
          (let loop ((count (1- dots)) (new-stil stil))
            (if (> count 0)
                (loop (1- count)
                      (ly:stencil-combine-at-edge new-stil X RIGHT stil 0.2))
                (ly:stencil-aligned-to new-stil X CENTER)))))
     \staccato
  #})

\relative c' {
  \tuplet 3/2 { \repeat tremolo 3 c8-\tongue #3 }
}



