\version "2.22.2"

\header {
  texidoc = "
Writing chants from right to left.

"
  doctitle = "Arabic chant"
}
%=> https://lists.gnu.org/archive/html/lilypond-user/2014-03/msg00048.html
% added by P.P.Schneider in March 2014.

%% pseudo F clef:

myClef = #"
0.000 1.546 moveto
0.000 1.659 0.090 1.749 0.203 1.749 curveto
0.316 1.749 0.406 1.659 0.406 1.546 curveto
0.406 1.436 0.316 1.342 0.203 1.342 curveto
0.090 1.342 0.000 1.436 0.000 1.546 curveto
closepath
fill

0.000 2.542 moveto
0.000 2.655 0.090 2.745 0.203 2.745 curveto
0.316 2.745 0.406 2.655 0.406 2.542 curveto
0.406 2.432 0.316 2.338 0.203 2.338 curveto
0.090 2.338 0.000 2.432 0.000 2.542 curveto
closepath
fill

1.461 3.092 moveto
2.148 3.092 2.629 2.741 2.629 2.092 curveto
2.629 1.046 1.582 0.444 0.574 0.014 curveto
0.563 0.003 0.551 -0.001 0.539 -0.001 curveto
0.512 -0.001 0.484 0.022 0.484 0.053 curveto
0.484 0.065 0.488 0.077 0.504 0.088 curveto
1.309 0.557 2.145 1.143 2.145 2.053 curveto
2.145 2.530 1.895 2.987 1.461 2.987 curveto
1.168 2.987 0.949 2.772 0.848 2.487 curveto
0.895 2.506 0.938 2.518 0.984 2.518 curveto
1.203 2.518 1.383 2.338 1.383 2.120 curveto
1.383 1.889 1.207 1.698 0.984 1.698 curveto
0.746 1.698 0.539 1.885 0.539 2.120 curveto
0.539 2.651 0.945 3.092 1.461 3.092 curveto
closepath
fill"

myClef_F = \markup {
  \with-dimensions #'(0 . 2.65) #'(0 . 3)
  \translate #'(0 . -2.05)
  \postscript #myClef
}

%%%% Flip flags
%=> http://lsr.di.unimi.it/LSR/Item?id=706

#(define (inverted-flag grob)
   (let* ((stem-grob (ly:grob-parent grob X))
          (dir (if (eqv? (ly:grob-property stem-grob 'direction) UP) "d" "u"))
          (flag (retrieve-glyph-flag "" dir "" grob))
          (line-thickness (ly:staff-symbol-line-thickness grob))
          (stem-thickness (ly:grob-property stem-grob 'thickness))
          (stem-width (* line-thickness stem-thickness))
          (stroke-style (ly:grob-property grob 'stroke-style))
          (stencil (if (null? stroke-style)
                       flag
                       (add-stroke-glyph flag stem-grob dir stroke-style "")))
          (rotated-flag (ly:stencil-rotate-absolute stencil 180 0 0)))
     (ly:stencil-translate rotated-flag (cons (- (/ stem-width 2)) 0))))

%%%% Flip staves and lyrics:
#(define-markup-command (flip layout props arg)
(markup?)
   (interpret-markup layout props
     (markup #:concat (#:null #:scale (cons -1 1) #:line (arg)))))

% Flip and customize time signature:
#(define ((myTimeSig up down) grob)
   (grob-interpret-markup grob
     (markup
      #:general-align Y  0
      #:override '(baseline-skip . 1)
      #:override '(font-size . 3)
      (#:line (#:flip (#:column (up down)))))))

%%%%%% example:

#(set-global-staff-size 18)

\include "arabic.ly"
% dod dob dosd \dwn dob dobsb dodsd do do

\header {
  title = "مجدُ مريم يتعظّم"
  subtitle = "(تراث قديم)"
  poet = "توزيع: حسام أديب ناشد"
  tagline = ""
}

lyr = \lyricmode {
  % mes. 1
  \markup\flip { "يـ" }
  \markup\flip { "ـتـ" }
  \markup\flip { "ـعـ" }
  \markup\flip { "ظم" }

  % mes.2
  \markup\flip { "مجـ" }
  \markup\flip { "دُُ" }
  \markup\flip { "مر" }
  \markup\flip { "يم" }

  % mes.3
  \markup\flip { "في" }
  \markup\flip { "الـمـ" }
  \markup\flip { "شا" }
  \markup\flip { "ر" }
  \markup\flip { "ق" }

  % mes.4
  \markup\flip { "والـ" }
  \markup\flip { "ـغـ" }
  \markup\flip { "روب" }

  % mes.5
  \markup\flip { "كـ" }
  \markup\flip { "ـرّ" }
  \markup\flip { "مو" }
  \markup\flip { "ها" }

  % mes.6
  \markup\flip { "عـ" }
  \markup\flip { "ـظّـ" }
  \markup\flip { "ـمو" }
  \markup\flip { "ها" }

  % mes. 7
  \markup\flip { "مـ" }
  \markup\flip { "ـلّـ" }
  \markup\flip { "كو" }
  \markup\flip { "ها" }

  % mes. 8
  \markup\flip { "في" }
  \markup\flip { "القـ" }
  \markup\flip { "ـلوب" }

}

Music =  {
  \new StaffGroup <<
    \new Staff
    \with {
       \override Clef.stencil = #(lambda (grob)
          (grob-interpret-markup grob #{ \markup\flip\musicglyph "clefs.G" #}))
    }
    \relative do''
    {
      %% arabic time signature:
      \override Score.TimeSignature.stencil = #(myTimeSig "٣" "٢")
      \time 3/2
      \set Staff.keyAlterations = #`((5 . ,FLAT)(2 . ,FLAT)(6 . ,FLAT))
      % mes.1
      | lab4. \once\stemUp sib8 do4.(sib8) \dwn lab 2 \breathe
      % mes.2
      | do4. \dwn lab8 \once\stemUp sib4.( \dwn lab8) sol2 \breathe
      % mes.3
      | \dwn lab4 sib do8( sib \dwn lab4 sib8 \dwn lab) sol fa
      % mes.4
      | \dwn lab4 sib8( \dwn lab) sol4.( fa8 sol2) \breathe
      \break
      \once\override Score.BarNumber.stencil =
      #(lambda (grob) (grob-interpret-markup grob #{ \markup\flip
          % arabic bar numbering option:
          \large "٥"
          % or occidental:
          %"5"
                        #}))
      % mes.5
      | fa4. \dwn mib8 fa4( sol) fa2 \breathe
      % mes.6
      | \dwn lab4. fa8 sol( fa sib \dwn lab) sol2 \breathe
      % mes.7
      | sib4 re8( do) do4.( sib8 do sib) \dwn lab4
      % mes.8
      | sib8( \dwn lab) sol4 \stemDown do8.[( sib16]
        \stemNeutral \dwn lab sib \dwn lab sol fa2) \breathe
      \bar "|."
    }
    \addlyrics\lyr
    \new Staff
    \with {
      instrumentName = \markup\flip " "
      \override Clef.stencil = #(lambda (grob)
         (grob-interpret-markup grob #{ \markup\flip\musicglyph "clefs.G" #}))
    }
    \relative do'
    {
      \set Staff.keyAlterations = #`((5 . ,FLAT)(2 . ,FLAT)(6 . ,FLAT))
      \time 3/2
      % mes.1
      | fa4. fa8 sol2 fa \breathe
      % mes.2
      | fa4. fa8 fa2 re \breathe
      % mes.3
      | fa4 fa fa2( re4) re
      % mes.5
      | fa4 fa re2( \dwn mib) \breathe
      % mes.5
      | R1.
      % mes.6
      | fa4. do8 re2 do \breathe
      % mes.7
      | re4 fa \dwn mib2 ( re4) re
      % mes.8
      | re4 re sol8.( fa16 \dwn mib4 do2) \breathe
      \bar "|."
    }
    \new Staff
    \with {
      \override Clef.stencil = #(lambda (grob)
        (grob-interpret-markup grob #{ \markup\flip\myClef_F #}))
    }
    \relative do'
    {
      \clef F
      \set Staff.keyAlterations = #`((5 . ,FLAT)(2 . ,FLAT)(6 . ,FLAT))
      \time 3/2
      do4. do8 do2 do \breathe
      % mes.2
      | \dwn lab4. do8 sib4.( do8) sib2 \breathe
      % mes.3
      | re4 sib \dwn lab8( sol fa4 sol8 \dwn lab) sib do
      % mes.4
      | re4 sol,8( \dwn lab) sib2 ( do) \breathe
      % mes.5
      | \dwn lab4. sol8 \dwn lab4( sib) \dwn lab2 \breathe
      % mes.6
      | fa4. \dwn lab8 sib( \dwn lab sol fa) mib2 \breathe
      % mes.7
      | fa4 fa sol2( fa4) fa
      % mes.8
      | sol4 sol \dwn mib8.( sol16 sib4 \dwn lab2) \breathe
      \bar "|."
    }
    \new Staff
    \with {
      \override Clef.stencil = #(lambda (grob)
         (grob-interpret-markup grob #{ \markup\flip\myClef_F #}))
    }
    \relative do
    {
      \clef F
      \set Staff.keyAlterations = #`((5 . ,FLAT)(2 . ,FLAT)(6 . ,FLAT))
      \time 3/2
        fa4. fa8 \dwn mib2 fa \breathe
      % mes.2
      | fa4. \dwn mib8 re2 re \breathe
      % mes.3
      | re4 re do2( \stemUp re4) re
      % mes.4
      | re4 re re2( do) \breathe \stemNeutral
      % mes.5
      | R1.
      % mes.6
      | R1.
      % mes.7
      | sib4 sib8( \dwn lab) sol2( \dwn lab8 sib) do4
      % mes.8
      | sol8( \dwn lab) sib4 do8.( re16 do4 fa2)  \breathe
      \bar "|."
    }
  >>
}

\markuplist {
  \vspace #1
  \fill-line {
    \null
    \flip {
      \score {
        \Music
        \layout {
          line-width = #180
          indent = 0
          \context {
            \Staff
            \override NoteHead.rotation = #'(120 0 0)
            \override NoteHead.stem-attachment = #'(-.86 . 0.4)
            \override Flag.stencil = #inverted-flag
            \override Accidental.stencil = #(lambda (grob)
               (ly:stencil-translate-axis
                (ly:stencil-scale
                  (ly:accidental-interface::print grob) -1 1) 0.3 X))
             \override KeySignature.stencil = #(lambda (grob)
               (ly:stencil-translate-axis
                (ly:stencil-scale
                 (ly:key-signature-interface::print grob) -1 1) 3 X))
            \override BreathingSign.text =
              \markup\bold\magnify #1.5 \raise #1 \flip\rotate #180 ","
          }
        }
      }
    }
  }
}

\score {
  \Music
  \midi { }
}

\paper {
  #(define fonts
     (make-pango-font-tree
       "Amiri"
       "Amiri"
       "Amiri"
       (/ staff-height pt 20)))
}

