\version "2.22.2"

\header {
  texidoc = "
Arpeggios are positioned by default directly to the left of a chord. If
a chord is preceded by a grace note, you can position the arpeggio in
front of the grace note by using an invisible note in a separate voice.
In order to span the two grace notes with the arpeggio, we add the
@code{Span_arpeggio_engraver} to the @code{Staff} context, and set
@code{connectArpeggios = ##t}. Here's an example from Chopin's Nocturne
No. 11 (Op. 37, No. 2): 

"
  doctitle = "Placing grace notes between arpeggios and chords"
}
%% http://lsr.di.unimi.it/LSR/Item?id=410

\score {
  \new PianoStaff { <<
    \new Staff \relative c' {
      \clef treble \key es \major
      \override PhrasingSlur.positions = #'(2.5 . 2.2)
      \override Slur.minimum-length = #3
      <f d bes>4^\( <g es des bes>
      << {
        \acciaccatura bes8\arpeggio
        \once \override NoteColumn.ignore-collision = ##t
        as4
      }
      \new Voice { \voiceTwo
        \hideNotes \grace bes,8\arpeggio
        \unHideNotes \oneVoice <es c>4
      } >> <g e bes>4\)\fermata |
      <f c as>4^\( <es! c g>
      << {
        \acciaccatura g8\arpeggio
        \once \override NoteColumn.ignore-collision = ##t
        f4
      }
      \new Voice { \voiceTwo
        \hideNotes \grace g,8\arpeggio
        \unHideNotes \oneVoice <c as>4
      } >> <es c g>4\)\fermata |
    }
    \new Staff \relative c {
      \clef bass \key es \major
      bes4 es as, c\fermata |
      <f, c'> <c c'> <f c'> <c c'>\fermata
    }
  >> }
  \layout {
    \context {
      \Staff
      \consists "Span_arpeggio_engraver"
      connectArpeggios = ##t
    }
  }
}






