\version "2.22.2"

\header {
  texidoc = "
If different stanzas of a song have different amount of syllables the
dispersion of the text may differ from stanza to stanza. This snippets
shows a possibility how notes of the second stanza can be printed as
cue notes when they differ from the notes of the first stanza. The
lyrics of the different stanzas are aligned correctly according to the
voice of the respective stanza.

"
  doctitle = "(Correctly aligned) different dispersions of text in different stanzas"
}
%% Remark:
%% This snippet produces a plethora of
%% warning: ignoring too many clashing note columns
%% If you really want to use it, you may invoke it on the command-line with
%% lilypond -lERROR <file.ly>
%% to surpress any warnings
%% Several methods to do it different in NR, though.
%%   --Harm

%If different stanzas of a song have different amount of syllables
%the dispersion of the text may differ from stanza to stanza.
%This snippets shows a possibility how notes of the second stanza can be printed as cue notes 
%when they differ from the notes of the first stanza. The snippets also positions the lyrics 
%of the different stanzas according to the voice of the respective stanza
%The first three bars demonstrate what to do when the first stanza has less syllabes 
%than the second one. The last bar demonstrates how a dashed slur can be used 
%when first stanza has more syllabes than the scond one.

firstStanzaLyrics = \lyricmode { 
  \set stanza = "1."
  First stan -- za has some text.
  And it goes on and on.
}

secondStanzaLyrics = \lyricmode { 
  \set stanza = "2."
  But se -- cond stan -- za has some more.
  But here it has less! 
}

firstStanzaVoice =
  \relative c'
    {  
      c2 d 
      e f
      g a
      b4 c c b
      a2 g
    }

secondStanzaVoice = 
\relative c'{
  %make notes smaller, so they appear as cue notes
  \override NoteHead.font-size = #-2       
  \override Voice.Stem.length = #5
  \override Flag.font-size = #-3     
  
  %since we want the lyrics of the second stanza to be aligned correctly, 
  %we need to enter the voice - even in the parts it equals the firstStanzaVoice
  
  %but we hide the secondStanzaVoice as long as it equals firstStanzaVoice
  \hideNotes
  %and we set \shiftOff so no extra space will be reserved for secondStanzaVoice in the system
  \shiftOff
  c2 d 
  %when secondStanzaVoice differs firstStanzaVoice we want to print it, so undo the hide
  \undo \hideNotes \shiftOn
  e4. e8 f4. f8      
  %hide secondStanzaVoice as it equals firstStanzaVoice again
  \hideNotes \shiftOff
   g2 a
   
   %when there is a melisma in the secondStanza while not in the firstStanza
   %(because secondStanzaLyrics has more syllabes than firstStanzaLyrics),
   %we want to print a dashed slur:
   b4 c \slurDashed c4( b) 
   a2 g
}

\score {
  \new Staff <<
    \new Voice = "first" { \firstStanzaVoice }
      \new Lyrics \lyricsto "first" { \firstStanzaLyrics }
    \new Voice = "second" { \secondStanzaVoice }
      \new Lyrics \lyricsto "second" { \secondStanzaLyrics }
  >>
}


