\version "2.22.2"

\header {
  texidoc = "
Lilypond provides the @code{\\cueDuring} and
@code{\\transposedCueDuring} commands to add cue notes. However, these
commands do neither print any cue instrument name, nor do they allow
the cue notes to be in a different clef than the quoting voice.


To be able to add cue instrument names and/or clef changes, as a
workaround, you can define your own function that sets
instrumentCueName and the clef for the staff. At the end of the cue
music (typically R1*2), you'll have to reset them again. This snippet
combines these steps into one function:


* @code{\\namedCueDuring #\"vIQuote\" #UP #\"V.I\" #\"Sop.\" @{ R1*3
@}} ... for adding instrument names, but no clef change

* @code{\\cleffedCueDuring #\"vIQuote\" #UP #\"V.I\" #\"treble\"
#\"Basso\" #\"bass\" @{ R1*3 @}} ... for instrument names plus clef
change



The example also shows how to modify properties of the displayed cue
instrument names: They are generated as InstrumentSwitch objects, which
support all different kinds of interfaces, like the font-interface to
modify font settings.


The disadvantage of this solution is that you always have to manually
give the instrument name and clef of the quoting voice, because
otherwise the function is not able to reset these. However, there is
currently no way known to me how to set the instrument name and clef
for a quoted voice automatically.



"
  doctitle = "Adding instrument name and clef change to cue notes"
}
%% http://lsr.di.unimi.it/LSR/Item?id=388

\paper { tagline = ##f }

% set the cue instrument name
setCue = #(define-music-function (instr) (string?)
   #{ \set Voice.instrumentCueName = $instr #} )

% generate a cue music section with instrument names
% Parameters: \namedCueDuring NameOfQuote CueDirection CueInstrument OriginalInstrument music
%                 -) NameOfQuote CueDirection music are the parameters for \cueDuring
%                 -) CueInstrument and OriginalInstrument are the displayed instrument names
% typical call:
% \namedCueDuring #"vIQuote" #UP #"V.I" #"Sop." { R1*3 }
%      This adds the notes from vIQuote (defined via \addQuote) to three measures, prints "V.I" at
%      the beginning of the cue notes and "Sop." at the end

namedCueDuring = #(define-music-function (cuevoice direction instrcue instr cuemusic) (string? number? string? string? ly:music?)
   #{
     \tag #'cued { \cueDuring #cuevoice #direction { \setCue #instrcue $cuemusic \setCue #instr } }
     \tag #'uncued $cuemusic
   #}
)

% set the cue instrument name and clef
setClefCue = #(define-music-function (instr clef) 
                                                     (string? string?)
   #{
     \once \override Staff.Clef.font-size = #-3 \clef $clef
     \set Voice.instrumentCueName = $instr
   #} )

% generate a cue music section with instrument names and clef changes
% Parameters: \cleffedCueDuring NameOfQuote CueDirection CueInstrument CueClef OriginalInstrument OriginalClef music
%                 -) NameOfQuote CueDirection music are the parameters for \cueDuring
%                 -) CueInstrument and OriginalInstrument are the displayed instrument names
%                 -) CueClef and OriginalClef are the clefs for the the cue notes and the clef of the containing voice
% typical call:
% \cleffedCueDuring #"vIQuote" #UP #"V.I" #"treble" #"Basso" #"bass" { R1*3 }
%      This adds the notes from vIQuote (defined via \addQuote) to three measures, prints "V.I" at
%      the beginning of the cue notes and "Basso" at the end. The clef is changed to treble at the 
%      beginning of the cue notes and reset to bass at the end

cleffedCueDuring = #(define-music-function (cuevoice direction instrcue clefcue instr clefinstr cuemusic) 
                                                        (string? number? string? string? string? string? ly:music?)
   #{
     \tag #'cued { \cueDuring #cuevoice #direction { \setClefCue #instrcue #clefcue $cuemusic \setClefCue #instr #clefinstr } }
     \tag #'uncued $cuemusic
   #}
)

% the voice, where cue notes are inserted:
Solo = \relative c'' {
   c2 c |
   \namedCueDuring #"vIQuote" #1 #"Vio.1" #"Sop." { R1*2 }
   c2 c \bar"||"
   \clef "bass"
   c,,2 c |
   \cleffedCueDuring #"vIQuote" #1 #"V1" #"treble" #"Basso" #"bass" { R1*2 }
   c2 c |
}

% the voice to be quoted
vI = \relative c'' { \clef "treble" f2 f | f f | f f | f f | f f | f f | f f | f f | }
\addQuote vIQuote { \vI }
% Lilypond >= 2.11 changed the spelling to \addQuote, so use the following command instead
% \addQuote vIQuote { \vI }

\layout {
  \context { \Score % set the font of the instrument names to a smaller size:
      \override InstrumentSwitch.font-size = #-3
  }
}


% Solo score with cue notes:
\score {
  \new Staff \keepWithTag #'cued \Solo
  \header { piece="Solo score with cue notes"}
}

% full score with cue notes removed
\score {
        <<
                \new Staff \keepWithTag #'uncued \Solo
                \new Staff \keepWithTag #'uncued \vI
        >>
  \header { piece="Full score with cue notes removed"}
}



